"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sort = exports.isMac = exports.getClickMetric = exports.blurEvent = exports.COUNT_METRIC = exports.CLICK_METRIC = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* @internal */
let COUNT_METRIC;
/* @internal */
exports.COUNT_METRIC = COUNT_METRIC;
(function (COUNT_METRIC) {
  COUNT_METRIC["UNHANDLED_ERROR"] = "unhandled_error";
  COUNT_METRIC["SEARCH_REQUEST"] = "search_request";
  COUNT_METRIC["SHORTCUT_USED"] = "shortcut_used";
  COUNT_METRIC["SEARCH_FOCUS"] = "search_focus";
})(COUNT_METRIC || (exports.COUNT_METRIC = COUNT_METRIC = {}));
let CLICK_METRIC;
/* @internal */
exports.CLICK_METRIC = CLICK_METRIC;
(function (CLICK_METRIC) {
  CLICK_METRIC["USER_NAVIGATED_TO_APPLICATION"] = "user_navigated_to_application";
  CLICK_METRIC["USER_NAVIGATED_TO_SAVED_OBJECT"] = "user_navigated_to_saved_object";
})(CLICK_METRIC || (exports.CLICK_METRIC = CLICK_METRIC = {}));
const getClickMetric = (metric, context) => {
  return [metric, `${metric}_${context}`];
};

/* @internal */
exports.getClickMetric = getClickMetric;
const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;

/* @internal */
exports.isMac = isMac;
const blurEvent = new FocusEvent('focusout', {
  bubbles: true
});
exports.blurEvent = blurEvent;
const sortByScore = (a, b) => {
  if (a.score < b.score) return 1;
  if (a.score > b.score) return -1;
  return 0;
};
const sortByTitle = (a, b) => {
  const titleA = a.title.toUpperCase(); // ignore upper and lowercase
  const titleB = b.title.toUpperCase(); // ignore upper and lowercase
  if (titleA < titleB) return -1;
  if (titleA > titleB) return 1;
  return 0;
};

/* @internal */
const sort = {
  byScore: sortByScore,
  byTitle: sortByTitle
};
exports.sort = sort;