"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUninstallTokensHandler = void 0;
var _services = require("../../services");
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUninstallTokensHandler = async (context, request, response) => {
  const uninstallTokenService = _services.appContextService.getUninstallTokenService();
  if (!uninstallTokenService) {
    return response.customError({
      statusCode: 500,
      body: {
        message: 'Uninstall Token Service is unavailable.'
      }
    });
  }
  try {
    const {
      page = 1,
      perPage = 20,
      policyId
    } = request.query;
    let body;
    if (policyId) {
      body = await uninstallTokenService.findTokensForPartialPolicyId(policyId, page, perPage);
    } else {
      body = await uninstallTokenService.getAllTokens(page, perPage);
    }
    return response.ok({
      body
    });
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.getUninstallTokensHandler = getUninstallTokensHandler;