"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.get({
    path: _constants.FLEET_PROXY_API_ROUTES.LIST_PATTERN,
    validate: false,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }, _handler.getAllFleetProxyHandler);
  router.post({
    path: _constants.FLEET_PROXY_API_ROUTES.CREATE_PATTERN,
    validate: _types.PostFleetProxyRequestSchema,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }, _handler.postFleetProxyHandler);
  router.put({
    path: _constants.FLEET_PROXY_API_ROUTES.UPDATE_PATTERN,
    validate: _types.PutFleetProxyRequestSchema,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }, _handler.putFleetProxyHandler);
  router.get({
    path: _constants.FLEET_PROXY_API_ROUTES.DELETE_PATTERN,
    validate: _types.GetOneFleetProxyRequestSchema,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }, _handler.getFleetProxyHandler);
  router.delete({
    path: _constants.FLEET_PROXY_API_ROUTES.DELETE_PATTERN,
    validate: _types.GetOneFleetProxyRequestSchema,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }, _handler.deleteFleetProxyHandler);
};
exports.registerRoutes = registerRoutes;