"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSearchResult = exports.createPackageSearchProvider = void 0;
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _common = require("../common");
var _hooks = require("./hooks");
var _constants = require("./constants");
var _icons = require("./services/icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const packageType = 'integration';
const createPackages$ = () => (0, _rxjs.from)((0, _hooks.sendGetPackages)()).pipe((0, _operators.map)(({
  error,
  data
}) => {
  var _data$response;
  if (error) {
    throw error;
  }
  return (_data$response = data === null || data === void 0 ? void 0 : data.response) !== null && _data$response !== void 0 ? _data$response : [];
}), (0, _operators.shareReplay)(1));

/** Exported for testing only @internal */
const toSearchResult = (pkg, application, basePath) => {
  var _pkg$policy_templates;
  const packageResult = {
    id: pkg.name,
    type: packageType,
    title: pkg.title,
    score: 80,
    icon: (0, _icons.getEuiIconType)(pkg, basePath),
    url: {
      path: `${application.getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID)}${_constants.pagePathGetters.integration_details_overview({
        pkgkey: pkg.name
      })[1]}`,
      prependBasePath: false
    }
  };
  const policyTemplateResults = (_pkg$policy_templates = pkg.policy_templates) === null || _pkg$policy_templates === void 0 ? void 0 : _pkg$policy_templates.map(policyTemplate => ({
    id: policyTemplate.name,
    type: packageType,
    title: policyTemplate.title,
    score: 80,
    icon: (0, _icons.getEuiIconType)(pkg, basePath, policyTemplate),
    url: {
      path: `${application.getUrlForApp(_common.INTEGRATIONS_PLUGIN_ID)}${_constants.pagePathGetters.integration_details_overview({
        pkgkey: pkg.name,
        integration: policyTemplate.name
      })[1]}`,
      prependBasePath: false
    }
  }));
  return [packageResult, ...(policyTemplateResults && policyTemplateResults.length > 1 ? policyTemplateResults : [])];
};
exports.toSearchResult = toSearchResult;
const createPackageSearchProvider = core => {
  const coreStart$ = (0, _rxjs.from)(core.getStartServices()).pipe((0, _operators.map)(([coreStart]) => coreStart), (0, _operators.shareReplay)(1));
  let packages$;
  const getPackages$ = () => {
    if (!packages$) {
      packages$ = createPackages$();
    }
    return packages$;
  };
  return {
    id: 'integrations',
    getSearchableTypes: () => [packageType],
    find: ({
      term,
      types
    }, {
      maxResults,
      aborted$
    }) => {
      if ((types === null || types === void 0 ? void 0 : types.includes(packageType)) === false) {
        return (0, _rxjs.of)([]);
      }
      const hasTypes = Boolean(types);
      const typesIncludePackage = hasTypes && types.includes(packageType);
      const noSearchTerm = !term;
      const includeAllPackages = typesIncludePackage && noSearchTerm;
      if (!includeAllPackages && noSearchTerm) {
        return (0, _rxjs.of)([]);
      }
      if (term) {
        term = term.toLowerCase();
      }
      const toSearchResults = (coreStart, packagesResponse) => {
        return packagesResponse.flatMap(includeAllPackages ? pkg => toSearchResult(pkg, coreStart.application, coreStart.http.basePath) : pkg => {
          if (!term) {
            return [];
          }
          return toSearchResult(pkg, coreStart.application, coreStart.http.basePath).filter(res => term && res.title.toLowerCase().includes(term));
        }).slice(0, maxResults);
      };
      return (0, _rxjs.combineLatest)([coreStart$, getPackages$()]).pipe((0, _operators.takeUntil)(aborted$), (0, _operators.map)(([coreStart, data]) => data ? toSearchResults(coreStart, data) : []));
    }
  };
};
exports.createPackageSearchProvider = createPackageSearchProvider;