"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGetActionStatus = sendGetActionStatus;
exports.sendGetAgentIncomingData = sendGetAgentIncomingData;
exports.sendGetAgentStatus = sendGetAgentStatus;
exports.sendGetAgentTags = sendGetAgentTags;
exports.sendGetAgentUploads = sendGetAgentUploads;
exports.sendGetAgents = sendGetAgents;
exports.sendGetAgentsAvailableVersions = sendGetAgentsAvailableVersions;
exports.sendPostAgentAction = sendPostAgentAction;
exports.sendPostAgentReassign = sendPostAgentReassign;
exports.sendPostAgentUnenroll = sendPostAgentUnenroll;
exports.sendPostAgentUpgrade = sendPostAgentUpgrade;
exports.sendPostBulkAgentReassign = sendPostBulkAgentReassign;
exports.sendPostBulkAgentTagsUpdate = sendPostBulkAgentTagsUpdate;
exports.sendPostBulkAgentUnenroll = sendPostBulkAgentUnenroll;
exports.sendPostBulkAgentUpgrade = sendPostBulkAgentUpgrade;
exports.sendPostBulkRequestDiagnostics = sendPostBulkRequestDiagnostics;
exports.sendPostCancelAction = sendPostCancelAction;
exports.sendPostRequestDiagnostics = sendPostRequestDiagnostics;
exports.sendPostRetrieveAgentsByActions = sendPostRetrieveAgentsByActions;
exports.sendPutAgentTagsUpdate = sendPutAgentTagsUpdate;
exports.useGetAgentStatus = useGetAgentStatus;
exports.useGetAgentUploads = void 0;
exports.useGetAgents = useGetAgents;
exports.useGetAgentsQuery = useGetAgentsQuery;
exports.useGetOneAgent = useGetOneAgent;
var _reactQuery = require("@tanstack/react-query");
var _services = require("../../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetOneAgent(agentId, options) {
  return (0, _use_request.useRequest)({
    path: _services.agentRouteService.getInfoPath(agentId),
    method: 'get',
    ...options
  });
}
function useGetAgents(query, options) {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.agentRouteService.getListPath(),
    query,
    ...options
  });
}
function useGetAgentsQuery(query, options = {}) {
  return (0, _reactQuery.useQuery)(['agents', query], () => sendGetAgents(query), {
    enabled: options.enabled
  });
}
function sendGetAgents(query, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getListPath(),
    query,
    ...options
  });
}
function useGetAgentStatus(query, options) {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.agentRouteService.getStatusPath(),
    query,
    ...options
  });
}
function sendGetAgentIncomingData(query) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getIncomingDataPath(),
    query
  });
}
function sendGetAgentStatus(query, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getStatusPath(),
    query,
    ...options
  });
}
function sendGetAgentTags(query, options) {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getListTagsPath(),
    query,
    ...options
  });
}
function sendPostAgentReassign(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.agentRouteService.getReassignPath(agentId),
    body,
    ...options
  });
}
function sendPostBulkAgentReassign(body, options) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.agentRouteService.getBulkReassignPath(),
    body,
    ...options
  });
}
function sendPostAgentUnenroll(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getUnenrollPath(agentId),
    method: 'post',
    body,
    ...options
  });
}
function sendPostBulkAgentUnenroll(body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getBulkUnenrollPath(),
    method: 'post',
    body,
    ...options
  });
}
function sendPostAgentUpgrade(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getUpgradePath(agentId),
    method: 'post',
    body,
    ...options
  });
}
function sendPostRequestDiagnostics(agentId, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getRequestDiagnosticsPath(agentId),
    method: 'post',
    ...options
  });
}
function sendPostBulkRequestDiagnostics(body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getBulkRequestDiagnosticsPath(),
    method: 'post',
    body,
    ...options
  });
}
function sendGetAgentUploads(agentId, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getListAgentUploads(agentId),
    method: 'get',
    ...options
  });
}
const useGetAgentUploads = (agentId, options) => {
  return (0, _use_request.useRequest)({
    path: _services.agentRouteService.getListAgentUploads(agentId),
    method: 'get',
    ...options
  });
};
exports.useGetAgentUploads = useGetAgentUploads;
function sendPostAgentAction(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getCreateActionPath(agentId),
    method: 'post',
    body,
    ...options
  });
}
function sendPostBulkAgentUpgrade(body, options) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getBulkUpgradePath(),
    method: 'post',
    body,
    ...options
  });
}
function sendGetActionStatus() {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getActionStatusPath(),
    method: 'get'
  });
}
function sendPostCancelAction(actionId) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getCancelActionPath(actionId),
    method: 'post'
  });
}
function sendPostRetrieveAgentsByActions(body) {
  return (0, _use_request.sendRequest)({
    path: _services.agentRouteService.getAgentsByActionsPath(),
    method: 'post',
    body
  });
}
function sendPutAgentTagsUpdate(agentId, body, options) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.agentRouteService.getUpdatePath(agentId),
    body,
    ...options
  });
}
function sendPostBulkAgentTagsUpdate(body, options) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.agentRouteService.getBulkUpdateTagsPath(),
    body,
    ...options
  });
}
function sendGetAgentsAvailableVersions() {
  return (0, _use_request.sendRequest)({
    method: 'get',
    path: _services.agentRouteService.getAvailableVersionsPath()
  });
}