"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetOneAgentPolicyFull = exports.useGetOneAgentPolicy = exports.useGetAgentPoliciesQuery = exports.useGetAgentPolicies = exports.sendUpdateAgentPolicy = exports.sendResetOnePreconfiguredAgentPolicy = exports.sendResetAllPreconfiguredAgentPolicies = exports.sendGetOneAgentPolicyFull = exports.sendGetOneAgentPolicy = exports.sendGetAgentPolicies = exports.sendDeleteAgentPolicy = exports.sendCreateAgentPolicy = exports.sendCopyAgentPolicy = void 0;
var _reactQuery = require("@tanstack/react-query");
var _services = require("../../services");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAgentPolicies = query => {
  return (0, _use_request.useRequest)({
    path: _services.agentPolicyRouteService.getListPath(),
    method: 'get',
    query
  });
};
exports.useGetAgentPolicies = useGetAgentPolicies;
const useGetAgentPoliciesQuery = query => {
  return (0, _reactQuery.useQuery)(['agentPolicies', query], () => (0, _use_request.sendRequestForRq)({
    path: _services.agentPolicyRouteService.getListPath(),
    method: 'get',
    query
  }));
};
exports.useGetAgentPoliciesQuery = useGetAgentPoliciesQuery;
const sendGetAgentPolicies = query => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getListPath(),
    method: 'get',
    query
  });
};
exports.sendGetAgentPolicies = sendGetAgentPolicies;
const useGetOneAgentPolicy = agentPolicyId => {
  return (0, _use_request.useConditionalRequest)({
    path: agentPolicyId ? _services.agentPolicyRouteService.getInfoPath(agentPolicyId) : undefined,
    method: 'get',
    shouldSendRequest: !!agentPolicyId
  });
};
exports.useGetOneAgentPolicy = useGetOneAgentPolicy;
const useGetOneAgentPolicyFull = agentPolicyId => {
  return (0, _use_request.useRequest)({
    path: _services.agentPolicyRouteService.getInfoFullPath(agentPolicyId),
    method: 'get'
  });
};
exports.useGetOneAgentPolicyFull = useGetOneAgentPolicyFull;
const sendGetOneAgentPolicyFull = (agentPolicyId, query = {}) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getInfoFullPath(agentPolicyId),
    method: 'get',
    query
  });
};
exports.sendGetOneAgentPolicyFull = sendGetOneAgentPolicyFull;
const sendGetOneAgentPolicy = agentPolicyId => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getInfoPath(agentPolicyId),
    method: 'get'
  });
};
exports.sendGetOneAgentPolicy = sendGetOneAgentPolicy;
const sendCreateAgentPolicy = (body, {
  withSysMonitoring
} = {
  withSysMonitoring: false
}) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getCreatePath(),
    method: 'post',
    body: JSON.stringify(body),
    query: withSysMonitoring ? {
      sys_monitoring: true
    } : {}
  });
};
exports.sendCreateAgentPolicy = sendCreateAgentPolicy;
const sendUpdateAgentPolicy = (agentPolicyId, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getUpdatePath(agentPolicyId),
    method: 'put',
    body: JSON.stringify(body)
  });
};
exports.sendUpdateAgentPolicy = sendUpdateAgentPolicy;
const sendCopyAgentPolicy = (agentPolicyId, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getCopyPath(agentPolicyId),
    method: 'post',
    body: JSON.stringify(body)
  });
};
exports.sendCopyAgentPolicy = sendCopyAgentPolicy;
const sendDeleteAgentPolicy = body => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getDeletePath(),
    method: 'post',
    body: JSON.stringify(body)
  });
};
exports.sendDeleteAgentPolicy = sendDeleteAgentPolicy;
const sendResetOnePreconfiguredAgentPolicy = agentPolicyId => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getResetOnePreconfiguredAgentPolicyPath(agentPolicyId),
    method: 'post',
    body: JSON.stringify({})
  });
};
exports.sendResetOnePreconfiguredAgentPolicy = sendResetOnePreconfiguredAgentPolicy;
const sendResetAllPreconfiguredAgentPolicies = () => {
  return (0, _use_request.sendRequest)({
    path: _services.agentPolicyRouteService.getResetAllPreconfiguredAgentPolicyPath(),
    method: 'post',
    body: JSON.stringify({})
  });
};
exports.sendResetAllPreconfiguredAgentPolicies = sendResetAllPreconfiguredAgentPolicies;