"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkedAgentCount = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../hooks");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the provided `count` number as a link to the Agents list if it is greater than zero
 */
const LinkedAgentCount = /*#__PURE__*/(0, _react.memo)(({
  count,
  agentPolicyId,
  showAgentText,
  ...otherEuiLinkProps
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const displayValue = showAgentText ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.linkedAgentCountText",
    defaultMessage: "{count, plural, one {# agent} other {# agents}}",
    values: {
      count
    }
  }) : count;
  return count > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, otherEuiLinkProps, {
    href: getHref('agent_list', {
      kuery: `${_constants.AGENTS_PREFIX}.policy_id : ${agentPolicyId}`
    })
  }), displayValue) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": otherEuiLinkProps['data-test-subj'],
    className: otherEuiLinkProps.className
  }, displayValue);
});
exports.LinkedAgentCount = LinkedAgentCount;