"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevtoolsRequestFlyoutButton = exports.ApiRequestFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DevtoolsRequestFlyoutButton = ({
  isDisabled,
  request,
  title,
  description,
  btnProps = {}
}) => {
  const flyoutRef = (0, _react.useRef)();
  const services = (0, _hooks.useStartServices)();
  const onClick = (0, _react.useCallback)(() => {
    const flyout = services.overlays.openFlyout((0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: services
    }, /*#__PURE__*/_react.default.createElement(ApiRequestFlyout, {
      closeFlyout: () => flyout.close(),
      request: request,
      title: title,
      description: description
    })), {
      theme$: services.theme.theme$
    }));
    flyoutRef.current = flyout;
  }, [services, request, title, description]);
  _react.default.useEffect(() => {
    return () => {
      var _flyoutRef$current;
      (_flyoutRef$current = flyoutRef.current) === null || _flyoutRef$current === void 0 ? void 0 : _flyoutRef$current.close();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    onClick: onClick,
    isDisabled: isDisabled
  }, btnProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.apiRequestFlyout.openFlyoutButton",
    defaultMessage: "Preview API request"
  }));
};
exports.DevtoolsRequestFlyoutButton = DevtoolsRequestFlyoutButton;
const ApiRequestFlyout = ({
  closeFlyout,
  title = _i18n.i18n.translate('xpack.fleet.apiRequestFlyout.title', {
    defaultMessage: 'Kibana API Request'
  }),
  request,
  description = _i18n.i18n.translate('xpack.fleet.apiRequestFlyout.description', {
    defaultMessage: 'Perform these request against Kibana'
  })
}) => {
  const {
    docLinks,
    application,
    share
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_public.ViewApiRequestFlyout
  // @ts-expect-error ViewApiRequestFlyout title type only allow string
  , {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.apiRequestFlyout.devtoolsRequestDescription",
      defaultMessage: "{learnMore}",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.api
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.apiRequestFlyout.learnMoreLink",
          defaultMessage: "Learn more about Fleet API"
        }))
      }
    })))),
    description: description,
    request: request,
    closeFlyout: closeFlyout,
    application: application,
    urlService: share.url
  });
};
exports.ApiRequestFlyout = ApiRequestFlyout;