"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesManifestApplyStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KubernetesManifestApplyStep = ({
  isComplete,
  fullCopyButton,
  onCopy
}) => {
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  // Otherwise the copy button is over the text
  const CommandCode = _styledComponents.default.pre({
    overflow: 'auto'
  });
  const onTextAreaClick = () => {
    if (onCopy) onCopy();
  };
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  const status = isComplete ? 'complete' : undefined;
  return {
    status,
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepKubernetesApplyManifest', {
      defaultMessage: 'Run the apply command'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.kubernetesCommandInstructions",
      defaultMessage: "From the directory where the manifest is downloaded, run the apply command."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      onClick: onTextAreaClick,
      fontSize: "m",
      isCopyable: !fullCopyButton,
      paddingSize: "m",
      css: `
            max-width: 1100px;
          `
    }, /*#__PURE__*/_react.default.createElement(CommandCode, null, "kubectl apply -f elastic-agent-managed-kubernetes.yml")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), fullCopyButton && /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: "kubectl apply -f elastic-agent-managed-kubernetes.yml"
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      iconType: "copyClipboard",
      size: "m",
      onClick: () => onCopyButtonClick(copy)
    }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollmentInstructions.copyButtonClicked",
      defaultMessage: "Copied"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollmentInstructions.copyButton",
      defaultMessage: "Copy to clipboard"
    }))))
  };
};
exports.KubernetesManifestApplyStep = KubernetesManifestApplyStep;