"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesInstructions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _common = require("../../../common");
var _k8s = require("../../hooks/use_request/k8s");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KubernetesInstructions = ({
  enrollmentAPIKey,
  onCopy,
  onDownload
}) => {
  var _settings$data2;
  const core = (0, _hooks.useStartServices)();
  const settings = (0, _hooks.useGetSettings)();
  const {
    notifications
  } = core;
  const [yaml, setYaml] = (0, _react.useState)('');
  const [fleetServer, setFleetServer] = (0, _react.useState)();
  const [copyButtonClicked, setCopyButtonClicked] = (0, _react.useState)(false);
  const [downloadButtonClicked, setDownloadButtonClicked] = (0, _react.useState)(false);
  const onCopyButtonClick = copy => {
    copy();
    setCopyButtonClicked(true);
    if (onCopy) onCopy();
  };
  const onDownloadButtonClick = downloadLink => {
    setDownloadButtonClicked(true);
    if (onDownload) onDownload();
    window.location.href = downloadLink;
  };
  (0, _react.useEffect)(() => {
    async function fetchK8sManifest() {
      try {
        var _settings$data;
        const fleetServerHosts = (_settings$data = settings.data) === null || _settings$data === void 0 ? void 0 : _settings$data.item.fleet_server_hosts;
        let host = '';
        if (fleetServerHosts !== undefined && fleetServerHosts.length !== 0) {
          setFleetServer(fleetServerHosts[0]);
          host = fleetServerHosts[0];
        }
        const query = {
          fleetServer: host,
          enrolToken: enrollmentAPIKey
        };
        const res = await (0, _k8s.sendGetK8sManifest)(query);
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching agent manifest');
        }
        setYaml(res.data.item);
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.loadk8sManifestErrorTitle', {
            defaultMessage: 'Error while fetching agent manifest'
          })
        });
      }
    }
    fetchK8sManifest();
  }, [notifications.toasts, enrollmentAPIKey, (_settings$data2 = settings.data) === null || _settings$data2 === void 0 ? void 0 : _settings$data2.item.fleet_server_hosts]);
  const downloadDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadDescriptionForK8s",
    defaultMessage: "Copy or download the Kubernetes manifest."
  });
  const k8sCopyYaml = /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: yaml
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onCopyButtonClick(copy),
    iconType: "copyClipboard"
  }, copyButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyPolicyButtonClicked",
    defaultMessage: "Copied"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.copyPolicyButton",
    defaultMessage: "Copy to clipboard"
  })));
  const downloadLink = core.http.basePath.prepend(`${_common.agentPolicyRouteService.getK8sFullDownloadPath()}?fleetServer=${fleetServer}&enrolToken=${enrollmentAPIKey}`);
  const k8sDownloadYaml = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    target: "_blank",
    iconSide: "right",
    iconType: "popout",
    onClick: () => onDownloadButtonClick(downloadLink)
  }, downloadButtonClicked ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadManifestButtonk8sClicked",
    defaultMessage: "Downloaded"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentInstructions.downloadManifestButtonk8s",
    defaultMessage: "Download Manifest"
  })));
  const k8sYaml = /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    style: {
      maxHeight: 300
    },
    fontSize: "m"
  }, yaml);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, downloadDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sYaml), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sCopyYaml)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, k8sDownloadYaml))));
};
exports.KubernetesInstructions = KubernetesInstructions;