"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instructions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _agent_requirements_page = require("../../applications/fleet/sections/agents/agent_requirements_page");
var _constants = require("../../constants");
var _use_fleet_server_unhealthy = require("../../applications/fleet/sections/agents/hooks/use_fleet_server_unhealthy");
var _ = require("..");
var _services = require("../../services");
var _advanced_tab = require("../../applications/fleet/components/fleet_server_instructions/advanced_tab");
var _steps = require("./steps");
var _default_missing_requirements = require("./default_missing_requirements");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Instructions = props => {
  var _fleetServerHosts$len, _fleetServerHosts$len2, _fleetStatus$missingR;
  const {
    agentPolicies,
    isFleetServerPolicySelected,
    fleetServerHosts,
    isLoadingAgentPolicies,
    selectionType,
    setSelectionType,
    mode,
    setMode,
    isIntegrationFlow,
    refreshAgentPolicies
  } = props;
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    isUnhealthy: isFleetServerUnhealthy,
    isLoading: isLoadingFleetServerHealth
  } = (0, _use_fleet_server_unhealthy.useFleetServerUnhealthy)();
  const {
    isFleetServerStandalone
  } = (0, _hooks.useFleetServerStandalone)();
  (0, _react.useEffect)(() => {
    refreshAgentPolicies();
  }, [refreshAgentPolicies]);
  const fleetServerAgentPolicies = (0, _react.useMemo)(() => agentPolicies.filter(pol => (0, _services.policyHasFleetServer)(pol)).map(pol => pol.id), [agentPolicies]);
  const {
    data: agents,
    isLoading: isLoadingAgents
  } = (0, _hooks.useGetAgents)({
    perPage: _constants.SO_SEARCH_LIMIT,
    showInactive: false,
    kuery: fleetServerAgentPolicies.length === 0 ? '' : `${_constants.AGENTS_PREFIX}.policy_id:${fleetServerAgentPolicies.map(id => `"${id}"`).join(' or ')}`
  });
  const fleetServers = (agents === null || agents === void 0 ? void 0 : agents.items) || [];
  const hasNoFleetServerHost = fleetStatus.isReady && ((_fleetServerHosts$len = fleetServerHosts === null || fleetServerHosts === void 0 ? void 0 : fleetServerHosts.length) !== null && _fleetServerHosts$len !== void 0 ? _fleetServerHosts$len : 0) === 0;
  const showAgentEnrollment = isFleetServerPolicySelected || isFleetServerStandalone || fleetStatus.isReady && !isFleetServerUnhealthy && fleetServers.length > 0 && ((_fleetServerHosts$len2 = fleetServerHosts === null || fleetServerHosts === void 0 ? void 0 : fleetServerHosts.length) !== null && _fleetServerHosts$len2 !== void 0 ? _fleetServerHosts$len2 : 0) > 0;
  const showFleetServerEnrollment = !isFleetServerStandalone && !isFleetServerPolicySelected && (fleetServers.length === 0 || isFleetServerUnhealthy || ((_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 ? _fleetStatus$missingR : []).some(r => r === _constants.FLEET_SERVER_PACKAGE));
  (0, _react.useEffect)(() => {
    var _props$cloudSecurityI;
    // If we have a cloudFormationTemplateUrl, we want to hide the selection type
    if ((_props$cloudSecurityI = props.cloudSecurityIntegration) !== null && _props$cloudSecurityI !== void 0 && _props$cloudSecurityI.cloudformationUrl) {
      setSelectionType(undefined);
    } else if (!isIntegrationFlow && showAgentEnrollment) {
      setSelectionType('radio');
    } else {
      setSelectionType('tabs');
    }
  }, [isIntegrationFlow, showAgentEnrollment, setSelectionType, props.cloudSecurityIntegration]);
  if (isLoadingAgents || isLoadingAgentPolicies || isLoadingFleetServerHealth) return /*#__PURE__*/_react.default.createElement(_.Loading, {
    size: "l"
  });
  if (hasNoFleetServerHost) {
    return null;
  }
  if (mode === 'managed') {
    if (showFleetServerEnrollment) {
      return /*#__PURE__*/_react.default.createElement(_agent_requirements_page.FleetServerRequirementPage, {
        showStandaloneTab: () => setMode('standalone')
      });
    } else if (showAgentEnrollment) {
      var _props$selectedPolicy, _props$cloudSecurityI2;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectionType === 'tabs' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollment.managedDescription",
        defaultMessage: "Enroll an Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      })), isFleetServerPolicySelected ? /*#__PURE__*/_react.default.createElement(_advanced_tab.AdvancedTab, {
        selectedPolicyId: (_props$selectedPolicy = props.selectedPolicy) === null || _props$selectedPolicy === void 0 ? void 0 : _props$selectedPolicy.id,
        onClose: () => undefined
      }) : /*#__PURE__*/_react.default.createElement(_steps.ManagedSteps, (0, _extends2.default)({}, props, {
        cloudFormationTemplateUrl: (_props$cloudSecurityI2 = props.cloudSecurityIntegration) === null || _props$cloudSecurityI2 === void 0 ? void 0 : _props$cloudSecurityI2.cloudformationUrl
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_default_missing_requirements.DefaultMissingRequirements, null);
  } else {
    return /*#__PURE__*/_react.default.createElement(StandaloneInstructions, props);
  }
};
exports.Instructions = Instructions;
const StandaloneInstructions = props => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.standaloneDescription",
    defaultMessage: "Run an Elastic Agent standalone to configure and update the agent manually on the host where the agent is installed."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_steps.StandaloneSteps, props));
};