"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicyWithPackagePolicies = useAgentPolicyWithPackagePolicies;
exports.useCloudSecurityIntegration = useCloudSecurityIntegration;
exports.useIsK8sPolicy = useIsK8sPolicy;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _common = require("../../../common");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Packages that requires custom elastic-agent manifest
const K8S_PACKAGES = new Set([_common.FLEET_KUBERNETES_PACKAGE, _common.FLEET_CLOUD_DEFEND_PACKAGE]);
function useAgentPolicyWithPackagePolicies(policyId) {
  const [agentPolicyWithPackagePolicies, setAgentPolicy] = (0, _react.useState)(null);
  const core = (0, _hooks.useStartServices)();
  const {
    notifications
  } = core;
  (0, _react.useEffect)(() => {
    async function loadPolicy(policyIdToLoad) {
      if (!policyIdToLoad) {
        return;
      }
      try {
        const agentPolicyRequest = await (0, _hooks.sendGetOneAgentPolicy)(policyIdToLoad);
        setAgentPolicy(agentPolicyRequest.data ? agentPolicyRequest.data.item : null);
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.loadPolicyErrorMessage', {
            defaultMessage: 'An error happened while loading the policy'
          })
        });
      }
    }
    loadPolicy(policyId);
  }, [policyId, notifications.toasts]);
  return {
    agentPolicyWithPackagePolicies
  };
}
function useIsK8sPolicy(agentPolicy) {
  const [isK8s, setIsK8s] = (0, _react.useState)('IS_LOADING');
  (0, _react.useEffect)(() => {
    async function checkifK8s() {
      if (!agentPolicy) {
        setIsK8s('IS_LOADING');
        return;
      }
      setIsK8s(agentPolicy.package_policies.some(isK8sPackage) ? 'IS_KUBERNETES' : 'IS_NOT_KUBERNETES');
    }
    checkifK8s();
  }, [agentPolicy]);
  return {
    isK8s
  };
}
function useCloudSecurityIntegration(agentPolicy) {
  const cloudSecurityIntegration = (0, _react.useMemo)(() => {
    if (!agentPolicy) {
      return undefined;
    }
    const integrationType = getCloudSecurityIntegrationTypeFromPackagePolicy(agentPolicy);
    const cloudformationUrl = (0, _services.getCloudFormationTemplateUrlFromAgentPolicy)(agentPolicy);
    return {
      integrationType,
      cloudformationUrl
    };
  }, [agentPolicy]);
  return {
    cloudSecurityIntegration
  };
}
const isK8sPackage = pkg => {
  var _pkg$package;
  const name = (_pkg$package = pkg.package) === null || _pkg$package === void 0 ? void 0 : _pkg$package.name;
  return K8S_PACKAGES.has(name);
};
const getCloudSecurityIntegrationTypeFromPackagePolicy = agentPolicy => {
  var _agentPolicy$package_, _packagePolicy$inputs, _packagePolicy$inputs2;
  const packagePolicy = agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.find(input => {
    var _input$package;
    return ((_input$package = input.package) === null || _input$package === void 0 ? void 0 : _input$package.name) === _common.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE;
  });
  if (!packagePolicy) return undefined;
  return packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : (_packagePolicy$inputs2 = _packagePolicy$inputs.find(input => input.enabled)) === null || _packagePolicy$inputs2 === void 0 ? void 0 : _packagePolicy$inputs2.policy_template;
};