"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeferredInstallationMsg = exports.DeferredAssetsWarning = exports.DEFERRED_ASSETS_WARNING_MSG = exports.DEFERRED_ASSETS_WARNING_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFERRED_ASSETS_WARNING_LABEL = _i18n.i18n.translate('xpack.fleet.packageCard.reauthorizationRequiredLabel', {
  defaultMessage: 'Reauthorization required'
});
exports.DEFERRED_ASSETS_WARNING_LABEL = DEFERRED_ASSETS_WARNING_LABEL;
const DEFERRED_ASSETS_WARNING_MSG = _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredInstallationsMsg', {
  defaultMessage: 'This package has at least one deferred installation which requires additional permissions to install and operate correctly.'
});
exports.DEFERRED_ASSETS_WARNING_MSG = DEFERRED_ASSETS_WARNING_MSG;
const getDeferredInstallationMsg = (numOfDeferredInstallations, {
  authz
}) => {
  var _authz$packagePrivile, _authz$packagePrivile2, _authz$packagePrivile3, _authz$packagePrivile4, _authz$packagePrivile5;
  const canReauthorizeTransforms = (_authz$packagePrivile = authz === null || authz === void 0 ? void 0 : (_authz$packagePrivile2 = authz.packagePrivileges) === null || _authz$packagePrivile2 === void 0 ? void 0 : (_authz$packagePrivile3 = _authz$packagePrivile2.transform) === null || _authz$packagePrivile3 === void 0 ? void 0 : (_authz$packagePrivile4 = _authz$packagePrivile3.actions) === null || _authz$packagePrivile4 === void 0 ? void 0 : (_authz$packagePrivile5 = _authz$packagePrivile4.canStartStopTransform) === null || _authz$packagePrivile5 === void 0 ? void 0 : _authz$packagePrivile5.executePackageAction) !== null && _authz$packagePrivile !== void 0 ? _authz$packagePrivile : false;
  if (!numOfDeferredInstallations) return DEFERRED_ASSETS_WARNING_MSG;
  if (canReauthorizeTransforms) {
    return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.reauthorizeDeferredInstallationsMsg', {
      defaultMessage: 'This package has {numOfDeferredInstallations, plural, one {one deferred installation} other {# deferred installations}}. Complete the installation to operate the package correctly.',
      values: {
        numOfDeferredInstallations
      }
    });
  }
  return _i18n.i18n.translate('xpack.fleet.epm.packageDetails.assets.deferredInstallationsWarning', {
    defaultMessage: 'This package has {numOfDeferredInstallations, plural, one {one deferred installation which requires} other {# deferred installations which require}} additional permissions to install and operate correctly.',
    values: {
      numOfDeferredInstallations
    }
  });
};
exports.getDeferredInstallationMsg = getDeferredInstallationMsg;
const DeferredAssetsWarning = ({
  numOfDeferredInstallations
}) => {
  const authz = (0, _hooks.useAuthz)();
  const tooltipContent = (0, _react.useMemo)(() => getDeferredInstallationMsg(numOfDeferredInstallations, {
    authz
  }), [numOfDeferredInstallations, authz]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    display: "inlineBlock",
    content: tooltipContent,
    title: DEFERRED_ASSETS_WARNING_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'alert',
    color: 'warning'
  }));
};
exports.DeferredAssetsWarning = DeferredAssetsWarning;