"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogstashInstructions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _helpers = require("./helpers");
var _hooks2 = require("./hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogstashInstructions = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(CollapsibleCallout, {
    iconType: "iInCircle",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.calloutTitle",
      defaultMessage: "Additional Logstash configuration required"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.logstashInstructions.description",
    defaultMessage: "Add an Elastic Agent pipeline configuration to Logstash to receive events from the Elastic Agent framework. {documentationLink}.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.logstash.inputElasticAgent
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.logstashInstructions.documentationLink",
        defaultMessage: "Learn more"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(LogstashInstructionSteps, null)));
};
exports.LogstashInstructions = LogstashInstructions;
const CollapsibleCallout = ({
  children,
  ...props
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, props, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.logstashInstructions.collapseInstructionsButtonLabel",
    defaultMessage: "Collapse steps"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsOpen(true),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.logstashInstructions.viewInstructionButtonLabel",
    defaultMessage: "View steps"
  })), isOpen && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children));
};
const LogstashInstructionSteps = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const logstashApiKey = (0, _hooks2.useLogstashApiKey)();
  const steps = (0, _react.useMemo)(() => [{
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.apiKeyStepDescription",
      defaultMessage: "We recommend authorizing Logstash to output to Elasticsearch with minimal privileges for Elastic Agent."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), logstashApiKey.apiKey ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m"
    }, /*#__PURE__*/_react.default.createElement("h5", null, "API Key"), logstashApiKey.apiKey, /*#__PURE__*/_react.default.createElement("div", {
      className: "euiCodeBlock__controls"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "euiCodeBlock__copyButton"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: logstashApiKey.apiKey
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: copy,
      iconType: "copyClipboard",
      color: "text",
      "aria-label": _i18n.i18n.translate('xpack.fleet.settings.logstashInstructions.copyApiKeyButtonLabel', {
        defaultMessage: 'Copy message'
      })
    }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: logstashApiKey.isLoading,
      onClick: logstashApiKey.generateApiKey
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.generateApiKeyButtonLabel",
      defaultMessage: "Generate API key"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.editPipelineStepDescription",
      defaultMessage: "Next, open the {pipelineConfFile} file and insert the following content:",
      values: {
        pipelineConfFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent-pipeline.conf")
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m",
      language: "yaml",
      isCopyable: true
    }, (0, _helpers.getLogstashPipeline)(logstashApiKey.apiKey)))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.addPipelineStepDescription",
      defaultMessage: "In your Logstash configuration directory, open the {pipelineFile} file and add the following configuration. Replace the path to your file.",
      values: {
        pipelineFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "pipelines.yml")
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "m",
      language: "yaml",
      isCopyable: true
    }, _helpers.LOGSTASH_CONFIG_PIPELINES))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.replaceStepDescription",
      defaultMessage: "Replace the parts between the brackets with your generated SSL certificate file paths. View {documentationLink} to generate the certificates.",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          href: docLinks.links.fleet.secureLogstash
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.logstashInstructions.ourDocumentationLink",
          defaultMessage: "our documentation"
        }))
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }))
  }, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.logstashInstructions.saveAndRestartStepDescription",
      defaultMessage: "Save the pipeline and restart Logstash so the changes take effect."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }))
  }], [logstashApiKey, docLinks]);
  return /*#__PURE__*/_react.default.createElement("ol", null, steps.map((step, idx) => /*#__PURE__*/_react.default.createElement("li", {
    key: idx
  }, step.children)));
};