"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDownloadSourceFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../constants");
var _hooks = require("../../../../hooks");
var _use_download_source_flyout_form = require("./use_download_source_flyout_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditDownloadSourceFlyout = ({
  onClose,
  downloadSource
}) => {
  (0, _hooks.useBreadcrumbs)('settings');
  const form = (0, _use_download_source_flyout_form.useDowloadSourceFlyoutForm)(onClose, downloadSource);
  const inputs = form.inputs;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: _constants.FLYOUT_MAX_WIDTH,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetEditDownloadSourcesFlyoutTitle"
  }, !downloadSource ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editDownloadSourcesFlyout.createTitle",
    defaultMessage: "Add new agent binary source",
    "data-test-subj": "editDownloadSourcesFlyout.add.title"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editDownloadSourcesFlyout.editTitle",
    defaultMessage: "Edit agent binary source",
    "data-test-subj": "editDownloadSourcesFlyout.edit.title"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editDownloadSourcesFlyout.nameInputLabel",
      defaultMessage: "Name"
    })
  }, inputs.nameInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "editDownloadSourcesFlyout.nameInput",
    fullWidth: true
  }, inputs.nameInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editDownloadSourcesFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "editDownloadSourcesFlyout.hostHelpText",
      id: "xpack.fleet.settings.editDownloadSourcesFlyout.hostsInputDescription",
      defaultMessage: "Address that your agents will use to download their binary from. Specify the path to the directory containing the binary. {guideLink}",
      values: {
        guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.settings,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.fleetSettingsLink",
          defaultMessage: "Learn more"
        }))
      }
    }),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editDownloadSourcesFlyout.hostInputLabel",
      defaultMessage: "Host"
    })
  }, inputs.hostInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "editDownloadSourcesFlyout.hostInput",
    fullWidth: true
  }, inputs.hostInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editDownloadSourcesFlyout.hostsInputPlaceholder', {
      defaultMessage: 'Specify host'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.defaultDownloadSourceInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "editDownloadSourcesFlyout.isDefaultSwitch"
  }, inputs.defaultDownloadSourceInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editDownloadSourcesFlyout.defaultSwitchLabel",
      defaultMessage: "Make this host the default for all agent policies."
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "editDownloadSourcesFlyout.cancelBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editDownloadSourcesFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "editDownloadSourcesFlyout.submitBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editDownloadSourcesFlyout.saveButton",
    defaultMessage: "Save and apply settings"
  }))))));
};
exports.EditDownloadSourceFlyout = EditDownloadSourceFlyout;