"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonTags = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCommonTags = (agents, visibleAgents, agentPolicies) => {
  const isManagedPolicy = agent => {
    const policy = agentPolicies.find(pol => pol.id === agent.policy_id);
    return !!policy && policy.is_managed;
  };
  const commonSelectedTags = agentList => agentList.reduce((acc, curr) => {
    var _curr$tags2;
    if (isManagedPolicy(curr)) {
      return acc;
    }
    if (acc.length < 1) {
      var _curr$tags;
      return (_curr$tags = curr.tags) !== null && _curr$tags !== void 0 ? _curr$tags : [];
    }
    return (0, _lodash.intersection)((_curr$tags2 = curr.tags) !== null && _curr$tags2 !== void 0 ? _curr$tags2 : [], acc);
  }, []);
  if (!Array.isArray(agents)) {
    // in query mode, returning common tags of all agents in current page
    // this is a simplification to avoid querying all agents from backend to determine common tags
    return commonSelectedTags(visibleAgents);
  }
  // taking latest tags from freshly loaded agents data, as selected agents array does not contain the latest tags of agents
  const freshSelectedAgentsData = visibleAgents.length > 0 ? visibleAgents.filter(newAgent => agents.find(existingAgent => existingAgent.id === newAgent.id)) : agents;
  return commonSelectedTags(freshSelectedAgentsData);
};
exports.getCommonTags = getCommonTags;