"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DashboardsButtons = () => {
  const dashboardLocator = (0, _hooks.useDashboardLocator)();
  const getDashboardHref = dashboardId => {
    return (dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
      dashboardId
    })) || '';
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(_constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_OVERVIEW),
    "data-test-subj": "ingestOverviewLinkButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.ingestOverviewlinkButton",
    defaultMessage: "Ingest Overview Metrics"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "dashboardApp",
    href: getDashboardHref(_constants.DASHBOARD_LOCATORS_IDS.ELASTIC_AGENT_AGENT_INFO),
    "data-test-subj": "agentInfoLinkButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.agentInfoLinkButton",
    defaultMessage: "Agent Info Metrics"
  })))));
};
exports.DashboardsButtons = DashboardsButtons;