"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPackagePolicyPage = exports.EditPackagePolicyForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _hooks2 = require("../../../../integrations/hooks");
var _components = require("../../../components");
var _components2 = require("../components");
var _components3 = require("../create_package_policy_page/single_page_layout/components");
var _components4 = require("../create_package_policy_page/components");
var _constants = require("../../../../../../common/constants");
var _services = require("../../../services");
var _services2 = require("../services");
var _components5 = require("./components");
var _hooks3 = require("./hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditPackagePolicyPage = /*#__PURE__*/(0, _react.memo)(() => {
  var _packagePolicy$data$i, _packagePolicy$data, _packagePolicy$data$i2, _packagePolicy$data$i3;
  const {
    params: {
      packagePolicyId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const packagePolicy = (0, _hooks2.useGetOnePackagePolicy)(packagePolicyId);
  const extensionView = (0, _hooks.useUIExtension)((_packagePolicy$data$i = (_packagePolicy$data = packagePolicy.data) === null || _packagePolicy$data === void 0 ? void 0 : (_packagePolicy$data$i2 = _packagePolicy$data.item) === null || _packagePolicy$data$i2 === void 0 ? void 0 : (_packagePolicy$data$i3 = _packagePolicy$data$i2.package) === null || _packagePolicy$data$i3 === void 0 ? void 0 : _packagePolicy$data$i3.name) !== null && _packagePolicy$data$i !== void 0 ? _packagePolicy$data$i : '', 'package-policy-edit');
  return /*#__PURE__*/_react.default.createElement(EditPackagePolicyForm, {
    packagePolicyId: packagePolicyId
    // If an extension opts in to this `useLatestPackageVersion` flag, we want to display
    // the edit form in an "upgrade" state regardless of whether the user intended to
    // "edit" their policy or "upgrade" it. This ensures the new policy generated will be
    // set to use the latest version of the package, not its current version.
    ,
    forceUpgrade: extensionView === null || extensionView === void 0 ? void 0 : extensionView.useLatestPackageVersion
  });
});
exports.EditPackagePolicyPage = EditPackagePolicyPage;
const EditPackagePolicyForm = /*#__PURE__*/(0, _react.memo)(({
  packagePolicyId,
  forceUpgrade = false,
  from = 'edit'
}) => {
  var _agentPolicy$id, _packagePolicy$packag, _packagePolicy$packag2, _packagePolicy$packag3, _packagePolicy$packag4, _packagePolicy$packag5, _packagePolicy$packag6, _packageInfo$name;
  const {
    application,
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [] = (0, _react.useState)();
  const {
    // data
    agentPolicy,
    isLoadingData,
    loadingError,
    packagePolicy,
    originalPackagePolicy,
    packageInfo,
    upgradeDryRunData,
    // form
    formState,
    setFormState,
    isUpgrade,
    isEdited,
    setIsEdited,
    savePackagePolicy,
    hasErrors,
    updatePackagePolicy,
    validationResults
  } = (0, _hooks3.usePackagePolicyWithRelatedData)(packagePolicyId, {
    forceUpgrade
  });
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  const policyId = (_agentPolicy$id = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) !== null && _agentPolicy$id !== void 0 ? _agentPolicy$id : '';

  // Retrieve agent count
  const [agentCount, setAgentCount] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    const getAgentCount = async () => {
      const {
        data
      } = await (0, _hooks.sendGetAgentStatus)({
        policyId
      });
      if (data !== null && data !== void 0 && data.results.total) {
        setAgentCount(data.results.total);
      }
    };
    if (isFleetEnabled && policyId) {
      getAgentCount();
    }
  }, [policyId, isFleetEnabled]);
  const handleExtensionViewOnChange = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    updatePackagePolicy(updatedPolicy);
    setFormState(prevState => {
      if (prevState === 'VALID' && !isValid) {
        return 'INVALID';
      }
      return prevState;
    });
  }, [updatePackagePolicy, setFormState]);

  // Cancel url + Success redirect Path:
  //  if `from === 'edit'` then it links back to Policy Details
  //  if `from === 'package-edit'`, or `upgrade-from-integrations-policy-list` then it links back to the Integration Policy List
  const cancelUrl = (0, _react.useMemo)(() => {
    if (packageInfo && policyId) {
      return from === 'package-edit' ? getHref('integration_details_policies', {
        pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo)
      }) : getHref('policy_details', {
        policyId
      });
    }
    return '/';
  }, [from, getHref, packageInfo, policyId]);
  const successRedirectPath = (0, _react.useMemo)(() => {
    if (packageInfo && policyId) {
      return from === 'package-edit' || from === 'upgrade-from-integrations-policy-list' ? getHref('integration_details_policies', {
        pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo)
      }) : getHref('policy_details', {
        policyId
      });
    }
    return '/';
  }, [from, getHref, packageInfo, policyId]);
  (0, _hooks3.useHistoryBlock)(isEdited);
  const onSubmit = async () => {
    if (formState === 'VALID' && hasErrors) {
      setFormState('INVALID');
      return;
    }
    if (agentCount !== 0 && formState !== 'CONFIRM') {
      setFormState('CONFIRM');
      return;
    }
    const {
      error
    } = await savePackagePolicy();
    if (!error) {
      setIsEdited(false);
      application.navigateToUrl(successRedirectPath);
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.updatedNotificationTitle', {
          defaultMessage: `Successfully updated '{packagePolicyName}'`,
          values: {
            packagePolicyName: packagePolicy.name
          }
        }),
        'data-test-subj': 'policyUpdateSuccessToast',
        text: agentCount && agentPolicy ? _i18n.i18n.translate('xpack.fleet.editPackagePolicy.updatedNotificationMessage', {
          defaultMessage: `Fleet will deploy updates to all agents that use the '{agentPolicyName}' policy`,
          values: {
            agentPolicyName: agentPolicy.name
          }
        }) : undefined
      });
    } else {
      if (error.statusCode === 409) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.failedNotificationTitle', {
            defaultMessage: `Error updating '{packagePolicyName}'`,
            values: {
              packagePolicyName: packagePolicy.name
            }
          }),
          toastMessage: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.failedConflictNotificationMessage', {
            defaultMessage: `Data is out of date. Refresh the page to get the latest policy.`
          })
        });
      } else {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.failedNotificationTitle', {
            defaultMessage: `Error updating '{packagePolicyName}'`,
            values: {
              packagePolicyName: packagePolicy.name
            }
          })
        });
      }
      setFormState('VALID');
    }
  };
  const extensionView = (0, _hooks.useUIExtension)((_packagePolicy$packag = (_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name) !== null && _packagePolicy$packag !== void 0 ? _packagePolicy$packag : '', 'package-policy-edit');
  const replaceDefineStepView = (0, _hooks.useUIExtension)((_packagePolicy$packag3 = (_packagePolicy$packag4 = packagePolicy.package) === null || _packagePolicy$packag4 === void 0 ? void 0 : _packagePolicy$packag4.name) !== null && _packagePolicy$packag3 !== void 0 ? _packagePolicy$packag3 : '', 'package-policy-replace-define-step');
  const extensionTabsView = (0, _hooks.useUIExtension)((_packagePolicy$packag5 = (_packagePolicy$packag6 = packagePolicy.package) === null || _packagePolicy$packag6 === void 0 ? void 0 : _packagePolicy$packag6.name) !== null && _packagePolicy$packag5 !== void 0 ? _packagePolicy$packag5 : '', 'package-policy-edit-tabs');
  if (replaceDefineStepView && extensionView) {
    throw new Error("'package-policy-create' and 'package-policy-replace-define-step' cannot both be registered as UI extensions");
  }
  const tabsViews = extensionTabsView === null || extensionTabsView === void 0 ? void 0 : extensionTabsView.tabs;
  const [selectedTab, setSelectedTab] = (0, _react.useState)(0);
  const layoutProps = {
    from: extensionView !== null && extensionView !== void 0 && extensionView.useLatestPackageVersion && isUpgrade ? 'upgrade-from-extension' : from,
    cancelUrl,
    agentPolicy,
    packageInfo,
    tabs: tabsViews !== null && tabsViews !== void 0 && tabsViews.length ? [{
      title: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.settingsTabName', {
        defaultMessage: 'Settings'
      }),
      isSelected: selectedTab === 0,
      onClick: () => {
        setSelectedTab(0);
      }
    }, ...tabsViews.map(({
      title
    }, index) => ({
      title,
      isSelected: selectedTab === index + 1,
      onClick: () => {
        setSelectedTab(index + 1);
      }
    }))] : []
  };
  const configurePackage = (0, _react.useMemo)(() => {
    var _packagePolicy$packag7;
    return agentPolicy && packageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedTab === 0 && /*#__PURE__*/_react.default.createElement(_components4.StepDefinePackagePolicy, {
      agentPolicy: agentPolicy,
      packageInfo: packageInfo,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID',
      isEditPage: true
    }), !extensionView && selectedTab === 0 && /*#__PURE__*/_react.default.createElement(_components4.StepConfigurePackagePolicy, {
      packageInfo: packageInfo,
      packagePolicy: packagePolicy,
      updatePackagePolicy: updatePackagePolicy,
      validationResults: validationResults,
      submitAttempted: formState === 'INVALID',
      isEditPage: true
    }), extensionView && packagePolicy.policy_id && ((_packagePolicy$packag7 = packagePolicy.package) === null || _packagePolicy$packag7 === void 0 ? void 0 : _packagePolicy$packag7.name) && originalPackagePolicy && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, selectedTab > 0 && tabsViews ? /*#__PURE__*/_react.default.createElement(tabsViews[selectedTab - 1].Component, {
      policy: originalPackagePolicy,
      newPolicy: packagePolicy,
      onChange: handleExtensionViewOnChange
    }) : /*#__PURE__*/_react.default.createElement(extensionView.Component, {
      policy: originalPackagePolicy,
      newPolicy: packagePolicy,
      onChange: handleExtensionViewOnChange
    }))) : null;
  }, [agentPolicy, packageInfo, packagePolicy, updatePackagePolicy, validationResults, formState, originalPackagePolicy, extensionView, handleExtensionViewOnChange, selectedTab, tabsViews]);
  const replaceConfigurePackage = replaceDefineStepView && originalPackagePolicy && packageInfo && /*#__PURE__*/_react.default.createElement(_components.ExtensionWrapper, null, /*#__PURE__*/_react.default.createElement(replaceDefineStepView.Component, {
    agentPolicy: agentPolicy,
    packageInfo: packageInfo,
    policy: originalPackagePolicy,
    newPolicy: packagePolicy,
    onChange: handleExtensionViewOnChange,
    validationResults: validationResults,
    isEditPage: true
  }));
  const {
    showDevtoolsRequest: isShowDevtoolRequestExperimentEnabled
  } = _services.ExperimentalFeaturesService.get();
  const showDevtoolsRequest = !_constants.HIDDEN_API_REFERENCE_PACKAGES.includes((_packageInfo$name = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) !== null && _packageInfo$name !== void 0 ? _packageInfo$name : '') && isShowDevtoolRequestExperimentEnabled;
  const devtoolRequest = (0, _react.useMemo)(() => (0, _services2.generateUpdatePackagePolicyDevToolsRequest)(packagePolicyId, (0, _lodash.omit)(packagePolicy, 'elasticsearch')), [packagePolicyId, packagePolicy]);
  return /*#__PURE__*/_react.default.createElement(_components3.CreatePackagePolicySinglePageLayout, (0, _extends2.default)({}, layoutProps, {
    "data-test-subj": "editPackagePolicy"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, isLoadingData ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : loadingError || !agentPolicy || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.editPackagePolicy.errorLoadingDataTitle",
      defaultMessage: "Error loading data"
    }),
    error: loadingError || _i18n.i18n.translate('xpack.fleet.editPackagePolicy.errorLoadingDataMessage', {
      defaultMessage: 'There was an error loading this integration information'
    })
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Breadcrumb, {
    agentPolicyName: agentPolicy.name,
    from: from,
    packagePolicyName: packagePolicy.name,
    pkgkey: (0, _services.pkgKeyFromPackageInfo)(packageInfo),
    pkgTitle: packageInfo.title,
    policyId: policyId
  }), formState === 'CONFIRM' && /*#__PURE__*/_react.default.createElement(_components2.ConfirmDeployAgentPolicyModal, {
    agentCount: agentCount,
    agentPolicy: agentPolicy,
    onConfirm: onSubmit,
    onCancel: () => setFormState('VALID')
  }), isUpgrade && upgradeDryRunData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components5.UpgradeStatusCallout, {
    dryRunData: upgradeDryRunData
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), replaceConfigurePackage || configurePackage, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, agentPolicy && packageInfo && formState === 'INVALID' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.errorOnSaveText",
    defaultMessage: "Your integration policy has errors. Please fix them before saving."
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "ghost",
    href: cancelUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.cancelButton",
    defaultMessage: "Cancel"
  }))), showDevtoolsRequest ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.DevtoolsRequestFlyoutButton, {
    isDisabled: formState !== 'VALID',
    btnProps: {
      color: 'ghost'
    },
    description: _i18n.i18n.translate('xpack.fleet.editPackagePolicy.devtoolsRequestDescription', {
      defaultMessage: 'This Kibana request updates a package policy.'
    }),
    request: devtoolRequest
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.EuiButtonWithTooltip, {
    onClick: onSubmit,
    isLoading: formState === 'LOADING'
    // Allow to save only if the package policy is upgraded or had been edited
    ,
    isDisabled: !canWriteIntegrationPolicies || formState !== 'VALID' || !isEdited && !isUpgrade,
    tooltip: !canWriteIntegrationPolicies ? {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicy.saveIntegrationTooltip",
        defaultMessage: "To save the integration policy, you must have security enabled and have the All privilege for Integrations. Contact your administrator."
      })
    } : undefined,
    iconType: "save",
    color: "primary",
    fill: true,
    "data-test-subj": "saveIntegration"
  }, isUpgrade ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.upgradeButton",
    defaultMessage: "Upgrade integration"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.editPackagePolicy.saveButton",
    defaultMessage: "Save integration"
  }))))))))));
});
exports.EditPackagePolicyForm = EditPackagePolicyForm;
const Breadcrumb = /*#__PURE__*/(0, _react.memo)(({
  agentPolicyName,
  from,
  packagePolicyName,
  pkgkey,
  pkgTitle,
  policyId
}) => {
  let breadcrumb = /*#__PURE__*/_react.default.createElement(PoliciesBreadcrumb, {
    policyName: agentPolicyName,
    policyId: policyId
  });
  if (from === 'package' || from === 'package-edit') {
    breadcrumb = /*#__PURE__*/_react.default.createElement(IntegrationsBreadcrumb, {
      pkgkey: pkgkey,
      pkgTitle: pkgTitle,
      policyName: packagePolicyName
    });
  } else if (from === 'upgrade-from-integrations-policy-list') {
    breadcrumb = /*#__PURE__*/_react.default.createElement(IntegrationsUpgradeBreadcrumb, {
      pkgkey: pkgkey,
      pkgTitle: pkgTitle,
      policyName: packagePolicyName
    });
  } else if (from === 'upgrade-from-fleet-policy-list') {
    breadcrumb = /*#__PURE__*/_react.default.createElement(UpgradeBreadcrumb, {
      policyName: agentPolicyName,
      policyId: policyId
    });
  }
  return breadcrumb;
});
const IntegrationsBreadcrumb = /*#__PURE__*/(0, _react.memo)(({
  pkgTitle,
  policyName,
  pkgkey
}) => {
  (0, _hooks2.useBreadcrumbs)('integration_policy_edit', {
    policyName,
    pkgTitle,
    pkgkey
  });
  return null;
});
const PoliciesBreadcrumb = ({
  policyName,
  policyId
}) => {
  (0, _hooks.useBreadcrumbs)('edit_integration', {
    policyName,
    policyId
  });
  return null;
};
const IntegrationsUpgradeBreadcrumb = /*#__PURE__*/(0, _react.memo)(({
  pkgTitle,
  policyName,
  pkgkey
}) => {
  (0, _hooks2.useBreadcrumbs)('integration_policy_upgrade', {
    policyName,
    pkgTitle,
    pkgkey
  });
  return null;
});
const UpgradeBreadcrumb = ({
  policyName,
  policyId
}) => {
  (0, _hooks.useBreadcrumbs)('upgrade_package_policy', {
    policyName,
    policyId
  });
  return null;
};