"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentStandalonePageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsYaml = require("js-yaml");
var _ = require("../..");
var _services = require("../../../../../../../../../services");
var _components = require("../../../../../../../components");
var _hooks = require("../../../../../../../../../hooks");
var _steps = require("../../../../../../../../../components/agent_enrollment_flyout/steps");
var _enrollment_instructions = require("../../../../../../../../../components/enrollment_instructions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallElasticAgentStandalonePageStep = props => {
  const {
    setIsManaged,
    agentPolicy,
    cancelUrl,
    onNext,
    cancelClickHandler
  } = props;
  const core = (0, _hooks.useStartServices)();
  const kibanaVersion = (0, _hooks.useKibanaVersion)();
  const [yaml, setYaml] = (0, _react.useState)('');
  const [commandCopied, setCommandCopied] = (0, _react.useState)(false);
  const [policyCopied, setPolicyCopied] = (0, _react.useState)(false);
  const [fullAgentPolicy, setFullAgentPolicy] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function fetchFullPolicy() {
      try {
        if (!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.id)) {
          return;
        }
        const query = {
          standalone: true,
          kubernetes: false
        };
        const res = await (0, _hooks.sendGetOneAgentPolicyFull)(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id, query);
        if (res.error) {
          throw res.error;
        }
        if (!res.data) {
          throw new Error('No data while fetching full agent policy');
        }
        setFullAgentPolicy(res.data.item);
      } catch (error) {
        core.notifications.toasts.addError(error, {
          title: 'Error'
        });
      }
    }
    fetchFullPolicy();
  }, [core.http.basePath, agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id, core.notifications.toasts]);
  (0, _react.useEffect)(() => {
    if (!fullAgentPolicy) {
      return;
    }
    setYaml((0, _services.fullAgentPolicyToYaml)(fullAgentPolicy, _jsYaml.safeDump));
  }, [fullAgentPolicy]);
  if (!agentPolicy) {
    return /*#__PURE__*/_react.default.createElement(_components.Error, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",
        defaultMessage: "Error loading package information"
      }),
      error: 'Agent policy not provided'
    });
  }
  const installManagedCommands = (0, _enrollment_instructions.StandaloneInstructions)(kibanaVersion);
  const downloadLink = core.http.basePath.prepend(`${_services.agentPolicyRouteService.getInfoFullDownloadPath(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id)}?standalone=true`);
  const steps = [(0, _steps.ConfigureStandaloneAgentStep)({
    selectedPolicyId: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id,
    yaml,
    downloadLink,
    isComplete: policyCopied,
    onCopy: () => setPolicyCopied(true)
  }), (0, _steps.InstallStandaloneAgentStep)({
    installCommand: installManagedCommands,
    isComplete: yaml && commandCopied,
    fullCopyButton: true,
    onCopy: () => setCommandCopied(true)
  })];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.StandaloneModeWarningCallout, {
    setIsManaged: setIsManaged
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps
  }), commandCopied && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.NotObscuredByBottomBar, null), /*#__PURE__*/_react.default.createElement(_.AgentStandaloneBottomBar, {
    cancelUrl: cancelUrl,
    onNext: onNext,
    cancelClickHandler: cancelClickHandler
  })));
};
exports.InstallElasticAgentStandalonePageStep = InstallElasticAgentStandalonePageStep;