"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDataPageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../../../hooks");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmDataPageStep = props => {
  const {
    enrolledAgentIds,
    packageInfo,
    isManaged
  } = props;
  const core = (0, _hooks.useStartServices)();
  const [agentDataConfirmed, setAgentDataConfirmed] = (0, _react.useState)(false);
  const {
    docLinks
  } = core;
  const troubleshootLink = docLinks.links.fleet.troubleshooting;
  const bottomBar = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.NotObscuredByBottomBar, null), /*#__PURE__*/_react.default.createElement(_.CreatePackagePolicyFinalBottomBar, {
    pkgkey: `${packageInfo.name}-${packageInfo.version}`
  }));
  if (!isManaged) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.ConfirmIncomingDataStandalone, {
      troubleshootLink: troubleshootLink
    }), bottomBar);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.ConfirmIncomingDataWithPreview, {
    agentIds: enrolledAgentIds,
    packageInfo: packageInfo,
    agentDataConfirmed: agentDataConfirmed,
    setAgentDataConfirmed: setAgentDataConfirmed,
    troubleshootLink: troubleshootLink
  }), !!agentDataConfirmed && bottomBar);
};
exports.ConfirmDataPageStep = ConfirmDataPageStep;