"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetComboBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERIC_DATASET_NAME = 'generic';
const DatasetComboBox = ({
  value,
  onChange,
  datastreams,
  isDisabled,
  pkgName = ''
}) => {
  var _datastreams$map;
  const datasetOptions = (_datastreams$map = datastreams.map(datastream => ({
    label: datastream.dataset,
    value: datastream
  }))) !== null && _datastreams$map !== void 0 ? _datastreams$map : [];
  const existingGenericStream = datasetOptions.find(ds => ds.label === GENERIC_DATASET_NAME);
  const valueAsOption = value ? typeof value === 'string' ? {
    label: value,
    value: {
      dataset: value,
      package: pkgName
    }
  } : {
    label: value.dataset,
    value: {
      dataset: value.dataset,
      package: value.package
    }
  } : undefined;
  const defaultOption = valueAsOption || existingGenericStream || {
    label: GENERIC_DATASET_NAME,
    value: {
      dataset: GENERIC_DATASET_NAME,
      package: pkgName
    }
  };
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([defaultOption]);
  (0, _react.useEffect)(() => {
    if (!value || typeof value === 'string') onChange(defaultOption.value);
  }, [value, defaultOption.value, onChange, pkgName]);
  const onDatasetChange = newSelectedOptions => {
    setSelectedOptions(newSelectedOptions);
    const dataStream = newSelectedOptions[0].value;
    onChange({
      dataset: newSelectedOptions[0].label,
      package: !dataStream || typeof dataStream === 'string' ? pkgName : dataStream.package
    });
  };
  const onCreateOption = (searchValue = '') => {
    const normalizedSearchValue = searchValue.trim().toLowerCase();
    if (!normalizedSearchValue) {
      return;
    }
    const newOption = {
      label: searchValue,
      value: {
        dataset: searchValue,
        package: pkgName
      }
    };
    setSelectedOptions([newOption]);
    onChange({
      dataset: searchValue,
      package: pkgName
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.datasetCombo.ariaLabel', {
      defaultMessage: 'Dataset combo box'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.datasetCombo.placeholder', {
      defaultMessage: 'Select a dataset'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: datasetOptions,
    selectedOptions: selectedOptions,
    onCreateOption: onCreateOption,
    onChange: onDatasetChange,
    customOptionText: _i18n.i18n.translate('xpack.fleet.datasetCombo.customOptionText', {
      defaultMessage: 'Add {searchValue} as a custom option',
      values: {
        searchValue: '{searchValue}'
      }
    }),
    isClearable: false,
    isDisabled: isDisabled,
    "data-test-subj": "datasetComboBox"
  }), valueAsOption && valueAsOption.value.package !== pkgName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.datasetCombo.warning",
    defaultMessage: "This data stream is managed by the {package} integration, {learnMore}.",
    values: {
      package: valueAsOption.value.package,
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.datasetCombo.warningTooltip",
          defaultMessage: "The destination data stream may not be designed to receive data from this integration, check that the mappings and ingest pipelines are compatible before sending data."
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank"
      }, _i18n.i18n.translate('xpack.fleet.datasetCombo.learnMoreLink', {
        defaultMessage: 'learn more'
      })))
    }
  }))));
};
exports.DatasetComboBox = DatasetComboBox;