"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyDeleteProvider = ({
  children,
  hasFleetServer
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();
  const [agentPolicy, setAgentPolicy] = (0, _react.useState)();
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isLoadingAgentsCount, setIsLoadingAgentsCount] = (0, _react.useState)(false);
  const [agentsCount, setAgentsCount] = (0, _react.useState)(0);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const deleteAgentPolicyPrompt = (agentPolicyToDelete, onSuccess = () => undefined) => {
    if (!agentPolicyToDelete) {
      throw new Error('No agent policy specified for deletion');
    }
    setIsModalOpen(true);
    setAgentPolicy(agentPolicyToDelete);
    fetchAgentsCount(agentPolicyToDelete);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setAgentPolicy(undefined);
    setIsLoading(false);
    setIsLoadingAgentsCount(false);
    setIsModalOpen(false);
  };
  const deleteAgentPolicy = async () => {
    setIsLoading(true);
    try {
      const {
        data
      } = await (0, _hooks.sendDeleteAgentPolicy)({
        agentPolicyId: agentPolicy
      });
      if (data) {
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.successSingleNotificationTitle', {
          defaultMessage: "Deleted agent policy '{id}'",
          values: {
            id: data.name || data.id
          }
        }));
        if (onSuccessCallback.current) {
          onSuccessCallback.current(agentPolicy);
        }
      } else {
        notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.failureSingleNotificationTitle', {
          defaultMessage: "Error deleting agent policy '{id}'",
          values: {
            id: agentPolicy
          }
        }));
      }
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.fatalErrorNotificationTitle', {
        defaultMessage: 'Error deleting agent policy'
      }));
    }
    closeModal();
  };
  const fetchAgentsCount = async agentPolicyToCheck => {
    if (!isFleetEnabled || isLoadingAgentsCount) {
      return;
    }
    setIsLoadingAgentsCount(true);
    const {
      data
    } = await (0, _hooks.sendRequest)({
      path: `/api/fleet/agents`,
      method: 'get',
      query: {
        kuery: `${_constants.AGENTS_PREFIX}.policy_id : ${agentPolicyToCheck}`
      }
    });
    setAgentsCount((data === null || data === void 0 ? void 0 : data.total) || 0);
    setIsLoadingAgentsCount(false);
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.deletePolicyTitle",
        defaultMessage: "Delete this agent policy?"
      }),
      onCancel: closeModal,
      onConfirm: deleteAgentPolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: isLoading || isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.loadingButtonLabel",
        defaultMessage: "Loading\u2026"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.deleteAgentPolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Delete policy"
      }),
      buttonColor: "danger",
      confirmButtonDisabled: isLoading || isLoadingAgentsCount || !!agentsCount
    }, isLoadingAgentsCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.loadingAgentsCountMessage",
      defaultMessage: "Checking amount of affected agents\u2026"
    }) : agentsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: _i18n.i18n.translate('xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentsTitle', {
        defaultMessage: 'Policy in use'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentsMessage",
      defaultMessage: "{agentsCount, plural, one {# agent is} other {# agents are}} assigned to this agent policy. Unassign these agents before deleting this policy.",
      values: {
        agentsCount
      }
    })) : hasFleetServer ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.fleetServerMessage",
      defaultMessage: "NOTE: This policy has Fleet Server integration, it is required for using Fleet."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.deleteAgentPolicy.confirmModal.irreversibleMessage",
      defaultMessage: "This action cannot be undone."
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(deleteAgentPolicyPrompt), renderModal());
};
exports.AgentPolicyDeleteProvider = AgentPolicyDeleteProvider;