"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyActionMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _constants = require("../../../constants");
var _experimental_features = require("../../../../../services/experimental_features");
var _agent_policy_yaml_flyout = require("./agent_policy_yaml_flyout");
var _agent_policy_copy_provider = require("./agent_policy_copy_provider");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyActionMenu = /*#__PURE__*/(0, _react.memo)(({
  agentPolicy,
  onCopySuccess,
  fullButton = false,
  enrollmentFlyoutOpenByDefault = false,
  onCancelEnrollment
}) => {
  const canWriteIntegrationPolicies = (0, _hooks.useAuthz)().integrations.writeIntegrationPolicies;
  const [isYamlFlyoutOpen, setIsYamlFlyoutOpen] = (0, _react.useState)(false);
  const [isEnrollmentFlyoutOpen, setIsEnrollmentFlyoutOpen] = (0, _react.useState)(enrollmentFlyoutOpenByDefault);
  const [isUninstallCommandFlyoutOpen, setIsUninstallCommandFlyoutOpen] = (0, _react.useState)(false);
  const {
    agentTamperProtectionEnabled
  } = _experimental_features.ExperimentalFeaturesService.get();
  const isFleetServerPolicy = (0, _react.useMemo)(() => {
    var _agentPolicy$package_;
    return (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.some(packagePolicy => {
      var _packagePolicy$packag;
      return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
    });
  }, [agentPolicy]);
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(false);
  const onContextMenuChange = (0, _react.useCallback)(open => {
    setIsContextMenuOpen(open);
  }, [setIsContextMenuOpen]);
  const onClose = (0, _react.useMemo)(() => {
    if (onCancelEnrollment) {
      return onCancelEnrollment;
    } else {
      return () => setIsEnrollmentFlyoutOpen(false);
    }
  }, [onCancelEnrollment, setIsEnrollmentFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_agent_policy_copy_provider.AgentPolicyCopyProvider, null, copyAgentPolicyPrompt => {
    const viewPolicyItem = /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "inspect",
      onClick: () => {
        setIsContextMenuOpen(false);
        setIsYamlFlyoutOpen(!isYamlFlyoutOpen);
      },
      key: "viewPolicy"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.viewPolicyText",
      defaultMessage: "View policy"
    }));
    const menuItems = agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed ? [viewPolicyItem] : [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "plusInCircle",
      onClick: () => {
        setIsContextMenuOpen(false);
        setIsEnrollmentFlyoutOpen(true);
      },
      key: "enrollAgents"
    }, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.addFleetServerActionText",
      defaultMessage: "Add Fleet Server"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.enrollAgentActionText",
      defaultMessage: "Add agent"
    })), viewPolicyItem, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      disabled: !canWriteIntegrationPolicies,
      icon: "copy",
      onClick: () => {
        setIsContextMenuOpen(false);
        copyAgentPolicyPrompt(agentPolicy, onCopySuccess);
      },
      key: "copyPolicy"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyActionMenu.copyPolicyActionText",
      defaultMessage: "Duplicate policy"
    }))];
    if (agentTamperProtectionEnabled && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed)) {
      menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "minusInCircle",
        onClick: () => {
          setIsContextMenuOpen(false);
          setIsUninstallCommandFlyoutOpen(true);
        },
        key: "getUninstallCommand",
        "data-test-subj": "uninstall-agents-command-menu-item"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyActionMenu.getUninstallCommand",
        defaultMessage: "Uninstall agents on this policy"
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isYamlFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_policy_yaml_flyout.AgentPolicyYamlFlyout, {
      policyId: agentPolicy.id,
      onClose: () => setIsYamlFlyoutOpen(false)
    })), isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
      agentPolicy: agentPolicy,
      onClose: onClose
    })), isUninstallCommandFlyoutOpen && /*#__PURE__*/_react.default.createElement(_components.UninstallCommandFlyout, {
      target: "agent",
      policyId: agentPolicy.id,
      onClose: () => setIsUninstallCommandFlyoutOpen(false)
    }), /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
      isOpen: isContextMenuOpen,
      onChange: onContextMenuChange,
      button: fullButton ? {
        props: {
          iconType: 'arrowDown',
          iconSide: 'right'
        },
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyActionMenu.buttonText",
          defaultMessage: "Actions"
        })
      } : undefined,
      items: menuItems
    }));
  });
});
exports.AgentPolicyActionMenu = AgentPolicyActionMenu;