"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressComponent = ProgressComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shape_factory = require("../reusable/shape_factory");
var _utils = require("./utils");
var _lib = require("../../../common/lib");
var _reusable = require("../reusable");
var _progress_drawer = require("./progress_drawer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ProgressComponent({
  onLoaded,
  parentNode,
  shape: shapeType,
  value,
  max,
  valueColor,
  barColor,
  valueWeight,
  barWeight,
  label,
  font
}) {
  const parentNodeDimensions = (0, _eui.useResizeObserver)(parentNode);
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: parentNode.offsetWidth,
    height: parentNode.offsetHeight
  });
  const [shapeData, setShapeData] = (0, _react.useState)((0, _reusable.getDefaultShapeData)());
  const shapeRef = (0, _react.useCallback)(node => {
    if (node !== null) {
      setShapeData(node.getData());
    }
  }, []);
  const [totalLength, setTotalLength] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    setDimensions({
      width: parentNode.offsetWidth,
      height: parentNode.offsetHeight
    });
    onLoaded();
  }, [onLoaded, parentNode, parentNodeDimensions]);
  const progressRef = (0, _react.useRef)(null);
  const textRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    setTotalLength(progressRef.current ? progressRef.current.getTotalLength() : 0);
  }, [shapeType, shapeData, progressRef]);
  const BarProgress = shapeData.shapeType ? (0, _shape_factory.getShapeContentElement)(shapeData.shapeType) : null;
  const shapeContentAttributes = {
    fill: 'none',
    stroke: barColor,
    strokeWidth: `${barWeight}px`
  };
  const percent = value / max;
  const to = totalLength * (1 - percent);
  const barProgressAttributes = {
    ...shapeData.shapeProps,
    fill: 'none',
    stroke: valueColor,
    strokeWidth: `${valueWeight}px`,
    strokeDasharray: totalLength,
    strokeDashoffset: Math.max(0, to)
  };
  const {
    width: labelWidth,
    height: labelHeight
  } = textRef.current ? textRef.current.getBBox() : {
    width: 0,
    height: 0
  };
  const offset = Math.max(valueWeight, barWeight);
  const updatedTextAttributes = shapeData.textAttributes ? (0, _utils.getTextAttributes)(shapeType, shapeData.textAttributes, offset, label) : {};
  const textAttributes = {
    style: font.spec,
    ...updatedTextAttributes
  };
  const updatedViewBox = (0, _utils.getViewBox)(shapeType, shapeData.viewBox, offset, labelWidth, labelHeight);
  const shapeAttributes = {
    id: (0, _lib.getId)('svg'),
    ...(dimensions || {}),
    viewBox: updatedViewBox
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "shapeAligner"
  }, /*#__PURE__*/_react.default.createElement(_progress_drawer.ProgressDrawerComponent, {
    shapeType: shapeType,
    shapeContentAttributes: {
      ...shapeContentAttributes,
      ref: progressRef
    },
    shapeAttributes: shapeAttributes,
    textAttributes: {
      ...textAttributes,
      ref: textRef
    },
    ref: shapeRef
  }, BarProgress && /*#__PURE__*/_react.default.createElement(BarProgress, barProgressAttributes)));
}