"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPartitionType = void 0;
var _charts = require("@elastic/charts");
var _types = require("../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getPartitionType = chartType => ({
  [_types.ChartTypes.PIE]: _charts.PartitionLayout.sunburst,
  [_types.ChartTypes.DONUT]: _charts.PartitionLayout.sunburst,
  [_types.ChartTypes.TREEMAP]: _charts.PartitionLayout.treemap,
  [_types.ChartTypes.MOSAIC]: _charts.PartitionLayout.mosaic,
  [_types.ChartTypes.WAFFLE]: _charts.PartitionLayout.waffle
})[chartType];
exports.getPartitionType = getPartitionType;