"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGoalConfig = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getCicleConfig = () => ({
  angleStart: Math.PI / 2,
  angleEnd: -(Math.PI + Math.PI / 2)
});
const getArcConfig = () => ({
  angleStart: Math.PI + (Math.PI - 2 * Math.PI / 2.5) / 2,
  angleEnd: -(Math.PI - 2 * Math.PI / 2.5) / 2
});
const empty = () => ({});
const getGoalConfig = type => ({
  [_common.GaugeShapes.HORIZONTAL_BULLET]: empty,
  [_common.GaugeShapes.VERTICAL_BULLET]: empty,
  [_common.GaugeShapes.ARC]: getArcConfig,
  [_common.GaugeShapes.CIRCLE]: getCicleConfig
})[type]();
exports.getGoalConfig = getGoalConfig;