"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _embeddable = require("./components/shared/exploratory_view/embeddable");
var _exploratory_view_url = require("./components/shared/exploratory_view/configurations/exploratory_view_url");
var _get_app_data_view = _interopRequireDefault(require("./utils/observability_data_views/get_app_data_view"));
var _data_handler = require("./data_handler");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class Plugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    this.initContext = initContext;
  }
  setup(core, plugins) {
    const appUpdater$ = this.appUpdater$;
    core.application.register({
      appRoute: _constants.APP_ROUTE,
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      euiIconType: 'logoObservability',
      id: 'exploratory-view',
      mount: async params => {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, pluginsStart] = await core.getStartServices();
        return renderApp({
          core: coreStart,
          appMountParameters: params,
          plugins: {
            ...pluginsStart
          },
          usageCollection: plugins.usageCollection,
          isDev: this.initContext.env.mode.dev
        });
      },
      title: _i18n.i18n.translate('xpack.exploratoryView.appTitle', {
        defaultMessage: 'Exploratory View'
      }),
      searchable: false,
      updater$: appUpdater$,
      keywords: ['observability', 'monitor', 'logs', 'metrics', 'apm', 'performance', 'trace', 'rum', 'user', 'experience']
    });
    return {
      register: _data_handler.registerDataHandler
    };
  }
  start(coreStart, pluginsStart) {
    this.appUpdater$.next(() => ({
      navLinkStatus: _coreApplicationBrowser.AppNavLinkStatus.hidden
    }));
    return {
      createExploratoryViewUrl: _exploratory_view_url.createExploratoryViewUrl,
      getAppDataView: (0, _get_app_data_view.default)(pluginsStart.dataViews),
      ExploratoryViewEmbeddable: (0, _embeddable.getExploratoryViewEmbeddable)({
        ...coreStart,
        ...pluginsStart
      })
    };
  }
}
exports.Plugin = Plugin;