"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterValuesList = FilterValuesList;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _polished = require("polished");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _filter_value_btn = require("../columns/filter_value_btn");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FilterValuesList({
  field,
  values,
  query,
  setQuery,
  label,
  loading,
  isNegated,
  nestedField,
  series,
  seriesId
}) {
  var _series$filters;
  const [isNestedOpen, setIsNestedOpen] = (0, _react.useState)({
    value: '',
    negate: false
  });
  const displayValues = (0, _lodash.map)(values, 'label').filter(opt => opt.toLowerCase().includes(query.toLowerCase()));
  const filters = (_series$filters = series === null || series === void 0 ? void 0 : series.filters) !== null && _series$filters !== void 0 ? _series$filters : [];
  const currFilter = filters.find(({
    field: fd
  }) => field === fd);
  const btnProps = {
    field,
    nestedField,
    seriesId,
    series,
    isNestedOpen,
    setIsNestedOpen
  };
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "o11yFilterValuesListFieldSearch",
    fullWidth: true,
    isLoading: loading,
    value: query,
    onChange: evt => {
      setQuery(evt.target.value);
    },
    placeholder: getSearchLabel(label)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ListWrapper, null, loading && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute",
    style: {
      top: 'initial'
    }
  })), displayValues.length === 0 && !loading && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textCenter"
  }, NO_RESULT_FOUND), displayValues.map(opt => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: opt
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true,
    color: "primary"
  }, isNegated !== false && /*#__PURE__*/_react.default.createElement(_filter_value_btn.FilterValueButton, (0, _extends2.default)({}, btnProps, {
    value: opt,
    negate: true,
    allSelectedValues: currFilter === null || currFilter === void 0 ? void 0 : currFilter.notValues
  })), /*#__PURE__*/_react.default.createElement(_filter_value_btn.FilterValueButton, (0, _extends2.default)({}, btnProps, {
    value: opt,
    negate: false,
    allSelectedValues: currFilter === null || currFilter === void 0 ? void 0 : currFilter.values
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
}
const NO_RESULT_FOUND = _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.noFilter', {
  defaultMessage: 'No filters found.'
});
const getSearchLabel = label => _i18n.i18n.translate('xpack.exploratoryView.filters.expanded.search', {
  defaultMessage: 'Search for {label}',
  values: {
    label
  }
});
const ListWrapper = _common.euiStyled.div`
  height: 370px;
  overflow-y: auto;
  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const Wrapper = _styledComponents.default.div`
  width: 400px;
`;