"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTypesSelect = DataTypesSelect;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_series_storage = require("../../hooks/use_series_storage");
var _exploratory_view_config = require("../../contexts/exploratory_view_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECT_DATA_TYPE = 'SELECT_DATA_TYPE';
function DataTypesSelect({
  seriesId,
  series
}) {
  const {
    setSeries,
    reportType
  } = (0, _use_series_storage.useSeriesStorage)();
  const [showOptions, setShowOptions] = (0, _react.useState)(false);
  const focusButton = (0, _react.useCallback)(ref => {
    ref === null || ref === void 0 ? void 0 : ref.focus();
  }, []);
  const onDataTypeChange = dataType => {
    if (String(dataType) !== SELECT_DATA_TYPE) {
      setSeries(seriesId, {
        dataType,
        time: series.time,
        name: `${dataType}-series-${seriesId + 1}`
      });
    }
  };
  const {
    dataTypes,
    reportConfigMap
  } = (0, _exploratory_view_config.useExploratoryView)();
  const options = dataTypes.filter(({
    id
  }) => {
    var _reportConfigMap$id;
    return (_reportConfigMap$id = reportConfigMap[id]) === null || _reportConfigMap$id === void 0 ? void 0 : _reportConfigMap$id.find(config => config({}).reportType === reportType);
  }).map(({
    id,
    label
  }) => ({
    value: id,
    inputDisplay: label
  }));
  const currDataType = dataTypes.find(dt => dt.id === series.dataType);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !series.dataType && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yDataTypesSelectButton",
      iconType: "plusInCircle",
      onClick: () => setShowOptions(prevState => !prevState),
      fill: true,
      size: "s",
      buttonRef: focusButton
    }, SELECT_DATA_TYPE_LABEL),
    isOpen: showOptions,
    closePopover: () => setShowOptions(prevState => !prevState)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, null, options.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: option.value,
    onClick: () => onDataTypeChange(option.value),
    label: option.inputDisplay
  })))), series.dataType && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: SELECT_DATA_TYPE_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, currDataType === null || currDataType === void 0 ? void 0 : currDataType.label)));
}
const SELECT_DATA_TYPE_LABEL = _i18n.i18n.translate('xpack.exploratoryView.selectDataType', {
  defaultMessage: 'Select data type'
});
const SELECT_DATA_TYPE_TOOLTIP = _i18n.i18n.translate('xpack.exploratoryView.selectDataTypeTooltip', {
  defaultMessage: 'Data type cannot be edited.'
});