"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationPlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
var _event_annotation_service = require("./event_annotation_service");
var _common = require("../common");
var _fetch_event_annotations = require("./fetch_event_annotations");
var _constants = require("../common/constants");
var _content_management = require("../common/content_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/** @public */
class EventAnnotationPlugin {
  setup(core, dependencies) {
    dependencies.expressions.registerFunction(_common.manualPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.manualRangeEventAnnotation);
    dependencies.expressions.registerFunction(_common.queryPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.eventAnnotationGroup);
    dependencies.expressions.registerFunction((0, _fetch_event_annotations.getFetchEventAnnotations)({
      getStartServices: core.getStartServices
    }));
    dependencies.contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: _i18n.i18n.translate('eventAnnotation.content.name', {
        defaultMessage: 'Annotation group'
      })
    });
    dependencies.visualizations.listingViewRegistry.add({
      title: _i18n.i18n.translate('eventAnnotation.listingViewTitle', {
        defaultMessage: 'Annotation groups'
      }),
      id: _constants.ANNOTATIONS_LISTING_VIEW_ID,
      getTableList: async props => {
        const [coreStart, pluginsStart] = await core.getStartServices();
        const eventAnnotationService = await new _event_annotation_service.EventAnnotationService(coreStart, pluginsStart.contentManagement, pluginsStart.savedObjectsManagement).getService();
        const ids = await pluginsStart.dataViews.getIds();
        const dataViews = await Promise.all(ids.map(id => pluginsStart.dataViews.get(id)));
        const services = {
          core: coreStart,
          savedObjectsTagging: pluginsStart.savedObjectsTagging,
          eventAnnotationService,
          PresentationUtilContextProvider: pluginsStart.presentationUtil.ContextProvider,
          dataViews,
          createDataView: pluginsStart.dataViews.create.bind(pluginsStart.dataViews),
          queryInputServices: {
            http: coreStart.http,
            docLinks: coreStart.docLinks,
            notifications: coreStart.notifications,
            uiSettings: coreStart.uiSettings,
            dataViews: pluginsStart.dataViews,
            unifiedSearch: pluginsStart.unifiedSearch,
            data: pluginsStart.data,
            storage: new _public.Storage(localStorage)
          }
        };
        const {
          getTableList
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./get_table_list')));
        return getTableList(props, services);
      }
    });
  }
  start(core, startDependencies) {
    return new _event_annotation_service.EventAnnotationService(core, startDependencies.contentManagement, startDependencies.savedObjectsManagement);
  }
}
exports.EventAnnotationPlugin = EventAnnotationPlugin;