"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigPanelRangeDatePicker = exports.ConfigPanelApplyAsRangeSwitch = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ = require("../..");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ConfigPanelApplyAsRangeSwitch = ({
  annotation,
  onChange,
  getDefaultRangeEnd
}) => {
  const isRange = (0, _.isRangeAnnotationConfig)(annotation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    className: "lnsRowCompressedMargin"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "lns-xyAnnotation-rangeSwitch",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, _i18n.i18n.translate('eventAnnotation.xyChart.applyAsRange', {
      defaultMessage: 'Apply as range'
    })),
    checked: isRange,
    onChange: () => {
      if (isRange) {
        const newPointAnnotation = {
          type: 'manual',
          key: {
            type: 'point_in_time',
            timestamp: annotation.key.timestamp
          },
          id: annotation.id,
          label: annotation.label === _helpers.defaultRangeAnnotationLabel ? _helpers.defaultAnnotationLabel : annotation.label,
          color: (0, _helpers.toLineAnnotationColor)(annotation.color),
          isHidden: annotation.isHidden
        };
        onChange(newPointAnnotation);
      } else if (annotation) {
        const newRangeAnnotation = {
          type: 'manual',
          key: {
            type: 'range',
            timestamp: annotation.key.timestamp,
            endTimestamp: getDefaultRangeEnd(annotation.key.timestamp)
          },
          id: annotation.id,
          label: annotation.label === _helpers.defaultAnnotationLabel ? _helpers.defaultRangeAnnotationLabel : annotation.label,
          color: (0, _helpers.toRangeAnnotationColor)(annotation.color),
          isHidden: annotation.isHidden
        };
        onChange(newRangeAnnotation);
      }
    },
    compressed: true
  }));
};
exports.ConfigPanelApplyAsRangeSwitch = ConfigPanelApplyAsRangeSwitch;
const ConfigPanelRangeDatePicker = ({
  value,
  label,
  prependLabel,
  onChange,
  calendarClassName,
  dataTestSubj = 'lnsXY_annotation_date_picker'
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: label,
    className: "lnsRowCompressedMargin"
  }, prependLabel ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    className: "lnsConfigPanelNoPadding",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "lnsConfigPanelDate__label"
    }, prependLabel)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    calendarClassName: calendarClassName,
    fullWidth: true,
    showTimeSelect: true,
    selected: value,
    onChange: onChange,
    dateFormat: "MMM D, YYYY @ HH:mm:ss.SSS",
    "data-test-subj": dataTestSubj
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    calendarClassName: calendarClassName,
    fullWidth: true,
    showTimeSelect: true,
    selected: value,
    onChange: onChange,
    dateFormat: "MMM D, YYYY @ HH:mm:ss.SSS",
    "data-test-subj": dataTestSubj
  }));
};
exports.ConfigPanelRangeDatePicker = ConfigPanelRangeDatePicker;