"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultQuery = exports.ConfigPanelQueryAnnotation = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/unified-field-list-plugin/public");
var _public2 = require("@kbn/visualization-ui-components/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultQuery = {
  query: '',
  language: 'kuery'
};
exports.defaultQuery = defaultQuery;
const ConfigPanelQueryAnnotation = ({
  annotation,
  dataView,
  onChange,
  queryInputShouldOpen,
  queryInputServices,
  appName
}) => {
  var _options$, _annotation$filter;
  const {
    hasFieldData
  } = (0, _public.useExistingFieldsReader)();
  // list only date fields
  const options = dataView.fields.filter(_public2.isFieldLensCompatible).filter(field => field.type === 'date' && field.displayName).map(field => {
    return {
      label: field.displayName,
      value: {
        type: 'field',
        field: field.name,
        dataType: field.type
      },
      exists: dataView.id ? hasFieldData(dataView.id, field.name) : false,
      compatible: true,
      'data-test-subj': `lns-fieldOption-${field.name}`
    };
  });
  const selectedField = (annotation === null || annotation === void 0 ? void 0 : annotation.timeField) || dataView.timeFieldName || ((_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value.field);
  const fieldIsValid = selectedField ? Boolean(dataView.getFieldByName(selectedField)) : true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasChildLabel: true,
    display: "rowCompressed",
    className: "lnsRowCompressedMargin",
    fullWidth: true,
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotation.queryInput', {
      defaultMessage: 'Annotation query'
    })
  }, /*#__PURE__*/_react.default.createElement(_public2.FilterQueryInput, {
    "data-test-subj": "annotation-query-based-query-input",
    initiallyOpen: queryInputShouldOpen,
    label: "",
    inputFilter: (_annotation$filter = annotation === null || annotation === void 0 ? void 0 : annotation.filter) !== null && _annotation$filter !== void 0 ? _annotation$filter : defaultQuery,
    onChange: query => {
      onChange({
        filter: {
          type: 'kibana_query',
          ...query
        }
      });
    },
    dataView: dataView,
    appName: appName,
    queryInputServices: queryInputServices
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('eventAnnotation.xyChart.annotation.queryField', {
      defaultMessage: 'Target date field'
    })
  }, /*#__PURE__*/_react.default.createElement(_public2.FieldPicker, {
    options: options,
    selectedOptions: selectedField ? [{
      label: selectedField,
      value: {
        type: 'field',
        field: selectedField
      }
    }] : [],
    onChoose: function (choice) {
      if (choice) {
        onChange({
          timeField: choice.field
        });
      }
    },
    fieldIsInvalid: !fieldIsValid,
    "data-test-subj": "lnsXY-annotation-query-based-field-picker"
  })));
};
exports.ConfigPanelQueryAnnotation = ConfigPanelQueryAnnotation;