"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.annotationsIconSet = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const annotationsIconSet = [{
  value: 'asterisk',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.asteriskIconLabel', {
    defaultMessage: 'Asterisk'
  })
}, {
  value: 'alert',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.alertIconLabel', {
    defaultMessage: 'Alert'
  })
}, {
  value: 'bell',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.bellIconLabel', {
    defaultMessage: 'Bell'
  })
}, {
  value: 'bolt',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.boltIconLabel', {
    defaultMessage: 'Bolt'
  })
}, {
  value: 'bug',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.bugIconLabel', {
    defaultMessage: 'Bug'
  })
}, {
  value: 'circle',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.circleIconLabel', {
    defaultMessage: 'Circle'
  }),
  icon: _chartIcons.IconCircle
}, {
  value: 'editorComment',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.commentIconLabel', {
    defaultMessage: 'Comment'
  })
}, {
  value: 'flag',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.flagIconLabel', {
    defaultMessage: 'Flag'
  })
}, {
  value: 'heart',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.heartLabel', {
    defaultMessage: 'Heart'
  })
}, {
  value: 'mapMarker',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.mapMarkerLabel', {
    defaultMessage: 'Map Marker'
  })
}, {
  value: 'pinFilled',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.mapPinLabel', {
    defaultMessage: 'Map Pin'
  })
}, {
  value: 'starEmpty',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.starLabel', {
    defaultMessage: 'Star'
  })
}, {
  value: 'starFilled',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.starFilledLabel', {
    defaultMessage: 'Star filled'
  })
}, {
  value: 'tag',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.tagIconLabel', {
    defaultMessage: 'Tag'
  })
}, {
  value: 'triangle',
  label: _i18n.i18n.translate('eventAnnotation.xyChart.iconSelect.triangleIconLabel', {
    defaultMessage: 'Triangle'
  }),
  icon: _chartIcons.IconTriangle,
  shouldRotate: true
}];
exports.annotationsIconSet = annotationsIconSet;