"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toRangeAnnotationColor = exports.toLineAnnotationColor = exports.sanitizeProperties = exports.defaultRangeAnnotationLabel = exports.defaultAnnotationRangeColor = exports.defaultAnnotationLabel = exports.defaultAnnotationColor = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultAnnotationColor = _uiTheme.euiLightVars.euiColorAccent;
// Do not compute it live as dependencies will add tens of Kbs to the plugin
exports.defaultAnnotationColor = defaultAnnotationColor;
const defaultAnnotationRangeColor = `#F04E981A`; // defaultAnnotationColor with opacity 0.1
exports.defaultAnnotationRangeColor = defaultAnnotationRangeColor;
const defaultAnnotationLabel = _i18n.i18n.translate('eventAnnotation.xyChart.defaultAnnotationLabel', {
  defaultMessage: 'Event'
});
exports.defaultAnnotationLabel = defaultAnnotationLabel;
const defaultRangeAnnotationLabel = _i18n.i18n.translate('eventAnnotation.xyChart.defaultRangeAnnotationLabel', {
  defaultMessage: 'Event range'
});
exports.defaultRangeAnnotationLabel = defaultRangeAnnotationLabel;
const toRangeAnnotationColor = (color = defaultAnnotationColor) => {
  return (0, _chromaJs.default)((0, _eui.transparentize)(color, 0.1)).hex().toUpperCase();
};
exports.toRangeAnnotationColor = toRangeAnnotationColor;
const toLineAnnotationColor = (color = defaultAnnotationRangeColor) => {
  return (0, _chromaJs.default)((0, _eui.transparentize)(color, 1)).hex().toUpperCase();
};
exports.toLineAnnotationColor = toLineAnnotationColor;
const sanitizeProperties = annotation => {
  if ((0, _.isRangeAnnotationConfig)(annotation)) {
    const rangeAnnotation = (0, _lodash.pick)(annotation, ['type', 'label', 'key', 'id', 'isHidden', 'color', 'outside']);
    return rangeAnnotation;
  }
  if ((0, _.isQueryAnnotationConfig)(annotation)) {
    const lineAnnotation = (0, _lodash.pick)(annotation, ['type', 'id', 'label', 'key', 'timeField', 'isHidden', 'lineStyle', 'lineWidth', 'color', 'icon', 'textVisibility', 'textField', 'filter', 'extraFields']);
    return lineAnnotation;
  }
  const lineAnnotation = (0, _lodash.pick)(annotation, ['type', 'id', 'label', 'key', 'isHidden', 'lineStyle', 'lineWidth', 'color', 'icon', 'textVisibility']);
  return lineAnnotation;
};
exports.sanitizeProperties = sanitizeProperties;