"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCopiedAnnotation = void 0;
var _manual_event_annotation = require("./manual_event_annotation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createCopiedAnnotation = (newId, timestamp, source) => {
  if (!source) {
    return (0, _manual_event_annotation.getDefaultManualAnnotation)(newId, timestamp);
  }
  return {
    ...source,
    id: newId
  };
};
exports.createCopiedAnnotation = createCopiedAnnotation;