"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.attemptToURIDecode = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Use this function with any match params coming from react router to safely decode values.
 * After an update to react router v6, this functions should be deprecated.
 * Known issue for navigation with special characters in paths
 * https://github.com/elastic/kibana/issues/82440
 */
const attemptToURIDecode = value => {
  let result = value;
  try {
    result = value ? decodeURIComponent(value) : value;
  } catch (e) {
    // do nothing
  }
  return result;
};
exports.attemptToURIDecode = attemptToURIDecode;