"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Groups = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flash_messages = require("../../../shared/flash_messages");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _layout = require("../../components/layout");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _add_group_modal = require("./components/add_group_modal");
var _clear_filters_link = require("./components/clear_filters_link");
var _groups_table = require("./components/groups_table");
var _table_filters = require("./components/table_filters");
var _groups_logic = require("./groups_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Groups = () => {
  const {
    messages
  } = (0, _kea.useValues)(_flash_messages.FlashMessagesLogic);
  const {
    getSearchResults,
    openNewGroupModal,
    resetGroups
  } = (0, _kea.useActions)(_groups_logic.GroupsLogic);
  const {
    groupsDataLoading,
    newGroupModalOpen,
    newGroup,
    groupListLoading,
    hasFiltersSet,
    groupsMeta: {
      page: {
        total_results: numGroups
      }
    },
    filteredSources,
    filterValue
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  const hasMessages = messages.length > 0;
  (0, _react.useEffect)(() => {
    getSearchResults(true);
    return resetGroups;
  }, [filteredSources, filterValue]);
  if (newGroup && hasMessages) {
    messages[0].description = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      to: (0, _routes.getGroupPath)(newGroup.id),
      color: "success",
      "data-test-subj": "NewGroupManageButton"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.newGroup.action', {
      defaultMessage: 'Manage Group'
    }));
  }
  const clearFilters = hasFiltersSet && /*#__PURE__*/_react.default.createElement(_clear_filters_link.ClearFiltersLink, null);
  const inviteUsersButton = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: _routes.USERS_AND_ROLES_PATH,
    "data-test-subj": "InviteUsersButton"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.inviteUsers.action', {
    defaultMessage: 'Invite users'
  }));
  const createGroupButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "AddGroupButton",
    fill: true,
    onClick: openNewGroupModal
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.addGroupForm.action', {
    defaultMessage: 'Create a group'
  }));
  const headerActions = [inviteUsersButton, createGroupButton];
  const noResults = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: !groupListLoading
  }, groupListLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, clearFilters, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.searchResults.notFoound', {
    defaultMessage: 'No results found.'
  })))));
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.GROUPS],
    pageViewTelemetry: "groups",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.heading', {
        defaultMessage: 'Manage groups'
      }),
      description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.description', {
        defaultMessage: 'Assign organizational content sources and users to groups to create relevant search experiences for various internal teams.'
      }),
      rightSideItems: headerActions
    },
    isLoading: groupsDataLoading
  }, /*#__PURE__*/_react.default.createElement(_table_filters.TableFilters, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), numGroups > 0 && !groupListLoading ? /*#__PURE__*/_react.default.createElement(_groups_table.GroupsTable, null) : noResults, newGroupModalOpen && /*#__PURE__*/_react.default.createElement(_add_group_modal.AddGroupModal, null));
};
exports.Groups = Groups;