"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddGroupModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _groups_logic = require("../groups_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_GROUP_HEADER = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.addGroup.heading', {
  defaultMessage: 'Add a group'
});
const ADD_GROUP_SUBMIT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.addGroup.submit.action', {
  defaultMessage: 'Add Group'
});
const ADD_GROUP_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.groups.addGroup.label', {
  defaultMessage: 'Group name'
});
const AddGroupModal = () => {
  const {
    closeNewGroupModal,
    saveNewGroup,
    setNewGroupName
  } = (0, _kea.useActions)(_groups_logic.GroupsLogic);
  const {
    newGroupNameErrors,
    newGroupName
  } = (0, _kea.useValues)(_groups_logic.GroupsLogic);
  const isInvalid = newGroupNameErrors.length > 0;
  const handleFormSumbit = e => {
    e.preventDefault();
    saveNewGroup();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeNewGroupModal,
    initialFocus: ".euiFieldText"
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSumbit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, ADD_GROUP_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: isInvalid,
    error: newGroupNameErrors,
    label: ADD_GROUP_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid,
    value: newGroupName,
    "data-test-subj": "AddGroupInput",
    onChange: e => setNewGroupName(e.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeNewGroupModal
  }, _constants.CANCEL_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !newGroupName,
    onClick: saveNewGroup,
    fill: true,
    "data-test-subj": "AddGroupSubmit"
  }, ADD_GROUP_SUBMIT))));
};
exports.AddGroupModal = AddGroupModal;