"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynchronizationRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../../../routes");
var _assets_and_objects = require("./assets_and_objects");
var _frequency = require("./frequency");
var _synchronization = require("./synchronization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SynchronizationRouter = () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: (0, _routes.getSourcesPath)(_routes.SOURCE_SYNCHRONIZATION_PATH, true)
}, /*#__PURE__*/_react.default.createElement(_synchronization.Synchronization, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: (0, _routes.getSourcesPath)(_routes.SYNC_FREQUENCY_PATH, true)
}, /*#__PURE__*/_react.default.createElement(_frequency.Frequency, {
  tabId: 0
})), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: (0, _routes.getSourcesPath)(_routes.BLOCKED_TIME_WINDOWS_PATH, true)
}, /*#__PURE__*/_react.default.createElement(_frequency.Frequency, {
  tabId: 1
})), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: (0, _routes.getSourcesPath)(_routes.ASSETS_AND_OBJECTS_PATH, true)
}, /*#__PURE__*/_react.default.createElement(_assets_and_objects.AssetsAndObjects, null)), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  from: (0, _routes.getSourcesPath)(_routes.OLD_OBJECTS_AND_ASSETS_PATH, true),
  to: (0, _routes.getSourcesPath)(_routes.ASSETS_AND_OBJECTS_PATH, true)
}));
exports.SynchronizationRouter = SynchronizationRouter;