"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reauthenticate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _query_params = require("../../../../../shared/query_params");
var _add_source_logic = require("./add_source_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Reauthenticate = ({
  name,
  header
}) => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    sourceId
  } = (0, _query_params.parseQueryParams)(search);
  const [formLoading, setFormLoading] = (0, _react.useState)(false);
  const {
    getSourceReConnectData
  } = (0, _kea.useActions)(_add_source_logic.AddSourceLogic);
  const {
    sourceConnectData: {
      oauthUrl
    }
  } = (0, _kea.useValues)(_add_source_logic.AddSourceLogic);
  (0, _react.useEffect)(() => {
    getSourceReConnectData(sourceId);
  }, []);
  const handleFormSubmit = e => {
    e.preventDefault();
    setFormLoading(true);
    window.location.replace(oauthUrl);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "flexStart",
    justifyContent: "spaceBetween",
    gutterSize: "xl",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "adding-a-source__connect-an-instance"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.reAuthenticate.body', {
    defaultMessage: 'Your {name} credentials are no longer valid. Please reauthenticate with the original credentials to resume content syncing.',
    values: {
      name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    type: "submit",
    isLoading: !oauthUrl || formLoading
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.reAuthenticate.button', {
    defaultMessage: 'Reauthenticate {name}',
    values: {
      name
    }
  })))));
};
exports.Reauthenticate = Reauthenticate;