"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalConnectorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_logic = require("../../../../../app_logic");
var _layout = require("../../../../../components/layout");
var _constants = require("../../../../../constants");
var _source_data = require("../../../source_data");
var _add_source_header = require("../add_source_header");
var _config_docs_links = require("../config_docs_links");
var _external_connector_documentation = require("./external_connector_documentation");
var _external_connector_form_fields = require("./external_connector_form_fields");
var _external_connector_logic = require("./external_connector_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalConnectorConfig = () => {
  const {
    baseServiceType
  } = (0, _reactRouterDom.useParams)();
  const sourceData = (0, _source_data.getSourceData)('external', baseServiceType);
  const {
    saveExternalConnectorConfig
  } = (0, _kea.useActions)(_external_connector_logic.ExternalConnectorLogic);
  const {
    formDisabled,
    buttonLoading,
    urlValid
  } = (0, _kea.useValues)(_external_connector_logic.ExternalConnectorLogic);
  const handleFormSubmission = e => {
    e.preventDefault();
    saveExternalConnectorConfig();
  };
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  if (!sourceData) {
    return null;
  }
  const {
    name,
    categories = [],
    configuration: {
      applicationLinkTitle,
      applicationPortalUrl,
      documentationUrl
    }
  } = sourceData;
  const saveButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    isLoading: buttonLoading,
    disabled: formDisabled,
    type: "submit"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.registerButtonLabel', {
    defaultMessage: 'Register deployment'
  }));
  const formActions = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, saveButton)));
  const connectorForm = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_config_docs_links.ConfigDocsLinks, {
    name: name,
    documentationUrl: documentationUrl,
    applicationPortalUrl: applicationPortalUrl,
    applicationLinkTitle: applicationLinkTitle,
    discussUrl: "https://discuss.elastic.co/c/enterprise-search/84"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: !urlValid
  }, /*#__PURE__*/_react.default.createElement(_external_connector_form_fields.ExternalConnectorFormFields, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), formActions));
  const configSteps = [{
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.addSource.externalConnectorConfig.stepTitle', {
      defaultMessage: 'Provide the appropriate configuration information'
    }),
    children: connectorForm
  }];
  const header = /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: baseServiceType || 'external',
    categories: categories
  });
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE, name],
    isLoading: false
  }, header, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_external_connector_documentation.ExternalConnectorDocumentation, {
    name: name,
    documentationUrl: documentationUrl
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: handleFormSubmission
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: configSteps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "primary",
    iconType: "email",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/kibana/feedback",
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.feedbackCallOutText', {
      defaultMessage: 'Have feedback about deploying a connector package? Let us know.'
    }))
  }))));
};
exports.ExternalConnectorConfig = ExternalConnectorConfig;