"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addCustomSource = exports.AddCustomSourceApiLogic = void 0;
var _create_api_logic = require("../../../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../../../shared/http");
var _app_logic = require("../../../../../app_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addCustomSource = async ({
  name,
  baseServiceType
}) => {
  const {
    isOrganization
  } = _app_logic.AppLogic.values;
  const route = isOrganization ? '/internal/workplace_search/org/create_source' : '/internal/workplace_search/account/create_source';
  const params = {
    service_type: 'custom',
    name,
    base_service_type: baseServiceType
  };
  const source = await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(params)
  });
  return {
    source
  };
};
exports.addCustomSource = addCustomSource;
const AddCustomSourceApiLogic = (0, _create_api_logic.createApiLogic)(['workplace_search', 'add_custom_source_api_logic'], addCustomSource);
exports.AddCustomSourceApiLogic = AddCustomSourceApiLogic;