"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeys = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _doc_links = require("../../../shared/doc_links");
var _external_url = require("../../../shared/enterprise_search_url/external_url");
var _layout = require("../../components/layout");
var _constants = require("../../constants");
var _api_keys_logic = require("./api_keys_logic");
var _api_key_flyout = require("./components/api_key_flyout");
var _api_keys_list = require("./components/api_keys_list");
var _constants2 = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeys = () => {
  const {
    fetchApiKeys,
    resetApiKeys,
    showApiKeyForm
  } = (0, _kea.useActions)(_api_keys_logic.ApiKeysLogic);
  const {
    meta,
    dataLoading,
    apiKeyFormVisible,
    apiTokens
  } = (0, _kea.useValues)(_api_keys_logic.ApiKeysLogic);
  (0, _react.useEffect)(() => {
    fetchApiKeys();
    return resetApiKeys;
  }, [meta.page.current]);
  const hasApiKeys = apiTokens.length > 0;
  const addKeyButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: showApiKeyForm
  }, _constants2.CREATE_KEY_BUTTON_LABEL);
  const emptyPrompt = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "editorStrike",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.API_KEYS_EMPTY_TITLE),
    body: _constants2.API_KEYS_EMPTY_BODY,
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      target: "_blank",
      iconType: "popout",
      href: _doc_links.docLinks.workplaceSearchApiKeys
    }, _constants2.API_KEYS_EMPTY_BUTTON_LABEL)
  });
  return /*#__PURE__*/_react.default.createElement(_layout.WorkplaceSearchPageTemplate, {
    pageChrome: [_constants.NAV.API_KEYS],
    pageHeader: {
      pageTitle: _constants.API_KEYS_TITLE,
      rightSideItems: [addKeyButton]
    },
    isLoading: dataLoading,
    emptyState: !hasApiKeys && emptyPrompt
  }, apiKeyFormVisible && /*#__PURE__*/_react.default.createElement(_api_key_flyout.ApiKeyFlyout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _constants2.ENDPOINT_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: _external_url.externalUrl.enterpriseSearchUrl,
    afterMessage: _constants2.COPIED_TOOLTIP
  }, copy => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": _constants2.COPY_API_ENDPOINT_BUTTON_LABEL
  }), _external_url.externalUrl.enterpriseSearchUrl))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, hasApiKeys ? /*#__PURE__*/_react.default.createElement(_api_keys_list.ApiKeysList, null) : emptyPrompt));
};
exports.ApiKeys = ApiKeys;