"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersAndRolesRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _constants2 = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UsersAndRolesRowActions = ({
  onManageClick,
  onDeleteClick,
  username
}) => {
  const [deleteModalVisible, setVisible] = (0, _react.useState)(false);
  const showDeleteModal = () => setVisible(true);
  const closeDeleteModal = () => setVisible(false);
  const title = username ? (0, _constants2.USER_MODAL_TITLE)(username) : _constants2.REMOVE_ROLE_MAPPING_TITLE;
  const text = username ? _constants2.USER_MODAL_TEXT : _constants2.ROLE_MODAL_TEXT;
  const confirmButton = username ? _constants2.REMOVE_USER_BUTTON : _constants2.REMOVE_ROLE_MAPPING_BUTTON;
  const deleteModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: closeDeleteModal,
    onConfirm: () => {
      onDeleteClick();
      closeDeleteModal();
    },
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: confirmButton,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, text));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteModalVisible && deleteModal, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: onManageClick,
    iconType: "pencil",
    "aria-label": _constants.MANAGE_BUTTON_LABEL
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: showDeleteModal,
    iconType: "trash",
    "aria-label": _constants.DELETE_BUTTON_LABEL
  }));
};
exports.UsersAndRolesRowActions = UsersAndRolesRowActions;