"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isManagedPipeline = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isIngestPipelineWithMetadata = pipeline => {
  return pipeline.hasOwnProperty('_meta');
};
const isManagedPipeline = pipeline => {
  if (isIngestPipelineWithMetadata(pipeline)) {
    return Boolean(pipeline._meta.managed);
  }
  return false;
};
exports.isManagedPipeline = isManagedPipeline;