"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetWorkplaceSearchChrome = exports.SetVectorSearchChrome = exports.SetSearchExperiencesChrome = exports.SetEsreChrome = exports.SetEnterpriseSearchContentChrome = exports.SetEnterpriseSearchChrome = exports.SetEnterpriseSearchApplicationsChrome = exports.SetElasticsearchChrome = exports.SetAppSearchChrome = exports.SetAnalyticsChrome = void 0;
var _react = require("react");
var _kea = require("kea");
var _constants = require("../../../../common/constants");
var _kibana = require("../kibana");
var _generate_breadcrumbs = require("./generate_breadcrumbs");
var _generate_title = require("./generate_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetEnterpriseSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.enterpriseSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEnterpriseSearchChrome = SetEnterpriseSearchChrome;
const SetAnalyticsChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.analyticsTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useAnalyticsBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetAnalyticsChrome = SetAnalyticsChrome;
const SetElasticsearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.elasticsearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useElasticsearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetElasticsearchChrome = SetElasticsearchChrome;
const SetAppSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.appSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useAppSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetAppSearchChrome = SetAppSearchChrome;
const SetEsreChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.esreTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useEsreBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEsreChrome = SetEsreChrome;
const SetWorkplaceSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.workplaceSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useWorkplaceSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetWorkplaceSearchChrome = SetWorkplaceSearchChrome;
const SetEnterpriseSearchContentChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.appSearchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchContentBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEnterpriseSearchContentChrome = SetEnterpriseSearchContentChrome;
const SetSearchExperiencesChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.searchExperiencesTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useSearchExperiencesBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetSearchExperiencesChrome = SetSearchExperiencesChrome;
const SetEnterpriseSearchApplicationsChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.appSearchTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchApplicationsBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)([_constants.APPLICATIONS_PLUGIN.NAV_TITLE, ...trail]));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEnterpriseSearchApplicationsChrome = SetEnterpriseSearchApplicationsChrome;
const SetVectorSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.vectorSearchTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useVectorSearchBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)([_constants.VECTOR_SEARCH_PLUGIN.NAV_TITLE, ...trail]));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};

// Small util - performantly reverses an array without mutating the original array
exports.SetVectorSearchChrome = SetVectorSearchChrome;
const reverseArray = array => array.slice().reverse();