"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddContentEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _welcome_dark = _interopRequireDefault(require("../../../assets/images/welcome_dark.svg"));
var _welcome_light = _interopRequireDefault(require("../../../assets/images/welcome_light.svg"));
var _routes = require("../../enterprise_search_content/routes");
var _doc_links = require("../doc_links");
var _react_router_helpers = require("../react_router_helpers");
require("./add_content_empty_prompt.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddContentEmptyPrompt = ({
  title,
  buttonLabel
}) => {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "addContentEmptyPrompt",
    justifyContent: "spaceBetween",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, title || _i18n.i18n.translate('xpack.enterpriseSearch.overview.emptyState.heading', {
    defaultMessage: 'Add content to Enterprise Search'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.emptyState.description', {
    defaultMessage: 'Your content is stored in an Elasticsearch index. Get started by creating an Elasticsearch index and selecting an ingestion method. Options include the Elastic web crawler, third party data integrations, or using Elasticsearch API endpoints.'
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.emptyState.description.line2', {
    defaultMessage: "Whether you're building a search experience with App Search or Elasticsearch, you can now get started here."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _reactRouterDom.generatePath)(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes.NEW_INDEX_PATH),
    shouldNotCreateHref: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true
  }, buttonLabel || _i18n.i18n.translate('xpack.enterpriseSearch.overview.emptyState.buttonTitle', {
    defaultMessage: 'Add content to Enterprise Search'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.start,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.emptyState.footerLinkTitle', {
    defaultMessage: 'Learn more'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "xl",
    float: "right",
    src: colorMode === 'LIGHT' ? _welcome_light.default : _welcome_dark.default,
    alt: _i18n.i18n.translate('xpack.enterpriseSearch.overview.searchIndices.image.altText', {
      defaultMessage: 'Search indices illustration'
    })
  }))));
};
exports.AddContentEmptyPrompt = AddContentEmptyPrompt;