"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticSearchSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _elser = _interopRequireDefault(require("../../../../assets/images/elser.svg"));
var _nlp = _interopRequireDefault(require("../../../../assets/images/nlp.svg"));
var _vector = _interopRequireDefault(require("../../../../assets/images/vector.svg"));
var _elser_panel = require("./elser_panel");
var _esre_guide_accordion = require("./esre_guide_accordion");
var _nlp_enrichment_panel = require("./nlp_enrichment_panel");
var _vector_search_panel = require("./vector_search_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SemanticSearchSection = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 4
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  justifyContent: "flexStart"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.semanticSearch.title",
  defaultMessage: "Set up semantic search"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.semanticSearch.description",
  defaultMessage: "ESRE combines your choice of these information retrieval tools."
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 6
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_esre_guide_accordion.EsreGuideAccordion, {
  id: "elserAccordion",
  "data-telemetry-id": "entSearch-esre-semanticSearch-elserAccordion",
  initialIsOpen: true,
  icon: _elser.default,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.elserAccordion.title', {
    defaultMessage: 'Elastic Learned Sparse Encoder'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.esre.elserAccordion.description', {
    defaultMessage: 'Instant semantic search capabilities'
  })
}, /*#__PURE__*/_react.default.createElement(_elser_panel.ElserPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_esre_guide_accordion.EsreGuideAccordion, {
  id: "vectorSearchAccordion",
  "data-telemetry-id": "entSearch-esre-semanticSearch-vectorSearchAccordion",
  icon: _vector.default,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.vectorSearchAccordion.title', {
    defaultMessage: 'Vector Search'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.esre.vectorSearchAccordion.description', {
    defaultMessage: 'Powerful similarity searches for unstructured data'
  })
}, /*#__PURE__*/_react.default.createElement(_vector_search_panel.VectorSearchPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_esre_guide_accordion.EsreGuideAccordion, {
  id: "nlpEnrichmentAccordion",
  "data-telemetry-id": "entSearch-esre-semanticSearch-nlpEnrichmentAccordion",
  icon: _nlp.default,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.nlpEnrichmentAccordion.title', {
    defaultMessage: 'NLP Enrichment'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.esre.nlpEnrichmentAccordion.description', {
    defaultMessage: 'Insightful data enrichment with trained ML models'
  })
}, /*#__PURE__*/_react.default.createElement(_nlp_enrichment_panel.NlpEnrichmentPanel, null))))));
exports.SemanticSearchSection = SemanticSearchSection;