"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RankAggregationSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _linear = _interopRequireDefault(require("../../../../assets/images/linear.svg"));
var _rrf = _interopRequireDefault(require("../../../../assets/images/rrf.svg"));
var _esre_guide_accordion = require("./esre_guide_accordion");
var _linear_combination_panel = require("./linear_combination_panel");
var _rrf_ranking_panel = require("./rrf_ranking_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RankAggregationSection = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 4
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  justifyContent: "flexStart"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.rankAggregationSection.title",
  defaultMessage: "Use a rank aggregation method"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.esre.rankAggregationSection.description",
  defaultMessage: "Optional methods for fusing or combining different rankings to achieve better overall ranking performance."
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 6
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_esre_guide_accordion.EsreGuideAccordion, {
  id: "rrfRankingAccordion",
  "data-telemetry-id": "entSearch-esre-rankAggregation-rrfRankingAccordion",
  icon: _rrf.default,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.rrfRankingAccordion.title', {
    defaultMessage: 'RRF hybrid ranking'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.esre.rrfRankingAccordion.description', {
    defaultMessage: 'Intelligently combines rankings without configuration'
  })
}, /*#__PURE__*/_react.default.createElement(_rrf_ranking_panel.RrfRankingPanel, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_esre_guide_accordion.EsreGuideAccordion, {
  id: "linearCombinationAccordion",
  "data-telemetry-id": "entSearch-esre-rankAggregation-linearCombinationAccordion",
  icon: _linear.default,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.esre.linearCombinationAccordion.title', {
    defaultMessage: 'Linear combination'
  }),
  description: _i18n.i18n.translate('xpack.enterpriseSearch.esre.linearCombinationAccordion.description', {
    defaultMessage: 'Weighted results from multiple rankings'
  })
}, /*#__PURE__*/_react.default.createElement(_linear_combination_panel.LinearCombinationPanel, null))))));
exports.RankAggregationSection = RankAggregationSection;