"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _is_version_mismatch = require("../../../common/is_version_mismatch");
var _http = require("../shared/http");
var _kibana = require("../shared/kibana");
var _version_mismatch = require("../shared/version_mismatch");
var _error_connecting = require("./components/error_connecting");
var _product_selector = require("./components/product_selector");
var _setup_guide = require("./components/setup_guide");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchOverview = ({
  access = {},
  workplaceSearch,
  enterpriseSearchVersion,
  kibanaVersion
}) => {
  var _workplaceSearch$acco;
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const showErrorConnecting = !!(config.host && errorConnectingMessage);
  const incompatibleVersions = !!(config.host && (0, _is_version_mismatch.isVersionMismatch)(enterpriseSearchVersion, kibanaVersion));
  const isWorkplaceSearchAdmin = !!(workplaceSearch !== null && workplaceSearch !== void 0 && (_workplaceSearch$acco = workplaceSearch.account) !== null && _workplaceSearch$acco !== void 0 && _workplaceSearch$acco.isAdmin);
  const showView = () => {
    if (incompatibleVersions) {
      return /*#__PURE__*/_react.default.createElement(_version_mismatch.VersionMismatchPage, {
        enterpriseSearchVersion: enterpriseSearchVersion,
        kibanaVersion: kibanaVersion
      });
    } else if (showErrorConnecting) {
      return /*#__PURE__*/_react.default.createElement(_error_connecting.ErrorConnecting, null);
    }
    return /*#__PURE__*/_react.default.createElement(_product_selector.ProductSelector, {
      isWorkplaceSearchAdmin: isWorkplaceSearchAdmin,
      access: access
    });
  };
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SETUP_GUIDE_PATH
  }, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuide, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ROOT_PATH
  }, showView()));
};
exports.EnterpriseSearchOverview = EnterpriseSearchOverview;